/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.rule;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import xaero.common.category.FilterObjectCategory;
import xaero.common.category.rule.ObjectCategoryRule;
import xaero.common.misc.ListFactory;

abstract class ObjectCategoryListRule<E, S>
extends ObjectCategoryRule<E, Object>
implements Iterable<String> {
    private final List<String> stringList;
    private final List<S> list;
    private final Function<E, S> getter;
    private final Comparator<S> comparator;
    private final Predicate<String> stringValidator;
    private final boolean includeInSuperCategory;

    ObjectCategoryListRule(@Nonnull String name, @Nonnull List<String> stringList, @Nonnull List<S> list, @Nonnull Function<E, S> getter, @Nonnull Comparator<S> comparator, @Nonnull Predicate<String> stringValidator, boolean includeInSuperCategory) {
        super(name);
        this.stringList = stringList;
        this.list = list;
        this.getter = getter;
        this.comparator = comparator;
        this.stringValidator = stringValidator;
        this.includeInSuperCategory = includeInSuperCategory;
    }

    public boolean inList(E object) {
        if (this.list.isEmpty()) {
            return false;
        }
        S s = this.getter.apply(object);
        return s != null && Collections.binarySearch(this.list, s, this.comparator) >= 0;
    }

    @Override
    public Iterator<String> iterator() {
        return this.stringList.iterator();
    }

    public Predicate<String> getStringValidator() {
        return this.stringValidator;
    }

    public boolean getIncludeInSuperCategory() {
        return this.includeInSuperCategory;
    }

    public static abstract class Builder<E, S, B extends Builder<E, S, B>> {
        protected final B self = this;
        protected final List<String> stringList;
        protected Function<E, S> getter;
        protected Comparator<S> comparator;
        private Function<String, List<S>> elementResolver;
        protected Function<String, String> stringFixer;
        protected Predicate<String> stringValidator;
        private final ListFactory listFactory;
        protected boolean includeInSuperCategory;

        public Builder(ListFactory listFactory) {
            this.stringList = listFactory.get();
            this.listFactory = listFactory;
        }

        public B setDefault() {
            this.stringList.clear();
            this.setGetter(null);
            this.setStringFixer(null);
            this.setElementResolver(null);
            this.setStringValidator(null);
            this.setIncludeInSuperCategory(false);
            this.setComparator((o1, o2) -> Integer.compare(o1.hashCode(), o2.hashCode()));
            return this.self;
        }

        public List<String> getList() {
            return this.stringList;
        }

        public B setElementResolver(Function<String, List<S>> elementResolver) {
            this.elementResolver = elementResolver;
            return this.self;
        }

        public B setGetter(Function<E, S> getter) {
            this.getter = getter;
            return this.self;
        }

        public B setComparator(Comparator<S> comparator) {
            this.comparator = comparator;
            return this.self;
        }

        public B setStringFixer(Function<String, String> stringFixer) {
            this.stringFixer = stringFixer;
            return this.self;
        }

        public B setStringValidator(Predicate<String> stringValidator) {
            this.stringValidator = stringValidator;
            return this.self;
        }

        public B setIncludeInSuperCategory(boolean includeInSuperCategory) {
            this.includeInSuperCategory = includeInSuperCategory;
            return this.self;
        }

        protected <C extends FilterObjectCategory<E, ?, S, ?, C>> ObjectCategoryListRule<E, S> build(List<C> subCategories, Function<C, ObjectCategoryListRule<E, S>> subListGetter, Function<C, ObjectCategoryListRule<E, S>> subListExceptionsGetter) {
            if (this.elementResolver == null || this.stringList == null || this.getter == null || this.comparator == null || this.stringFixer == null) {
                throw new IllegalStateException("required fields not set!");
            }
            HashSet<S> effectiveSet = new HashSet<S>();
            for (String stringElement : this.stringList) {
                String validatedString = this.stringFixer.apply(stringElement);
                List<S> resolvedElement = this.elementResolver.apply(validatedString);
                if (resolvedElement == null || resolvedElement.isEmpty()) continue;
                effectiveSet.addAll(resolvedElement);
            }
            for (FilterObjectCategory subCategory : subCategories) {
                ObjectCategoryListRule<E, S> subList = subListGetter.apply(subCategory);
                if (!subList.getIncludeInSuperCategory()) continue;
                ObjectCategoryListRule subListExceptions = subListExceptionsGetter.apply(subCategory);
                ((ObjectCategoryListRule)subList).list.stream().filter(s -> subListExceptions == null || !subListExceptions.list.contains(s)).forEach(effectiveSet::add);
            }
            List effectiveList = this.listFactory.get();
            effectiveList.addAll(effectiveSet);
            Collections.sort(effectiveList, this.comparator);
            return this.buildInternally(effectiveList);
        }

        protected abstract ObjectCategoryListRule<E, S> buildInternally(List<S> var1);
    }
}

