/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.TRandomTickPart;
import codechicken.multipart.block.TileMultiPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

class WorldTickScheduler {
    @CapabilityInject(value=WorldTickScheduler.class)
    private static Capability<WorldTickScheduler> WORLD_CAPABILITY = null;
    @CapabilityInject(value=ChunkScheduler.class)
    private static Capability<ChunkScheduler> CHUNK_CAPABILITY = null;
    private final ServerWorld world;
    private final Map<ChunkPos, ChunkScheduler> tickingChunks = new HashMap<ChunkPos, ChunkScheduler>();

    public static WorldTickScheduler getInstance(ServerWorld level) {
        return (WorldTickScheduler)level.getCapability(WORLD_CAPABILITY, null).orElseThrow(() -> new RuntimeException("Should never happen..."));
    }

    public static ChunkScheduler getInstance(Chunk world) {
        return (ChunkScheduler)world.getCapability(CHUNK_CAPABILITY, null).orElseThrow(() -> new RuntimeException("Should never happen..."));
    }

    WorldTickScheduler(ServerWorld world) {
        this.world = world;
    }

    public void onChunkUnload(ChunkPos pos) {
        this.tickingChunks.remove(pos);
    }

    public void tick() {
        if (!this.tickingChunks.isEmpty()) {
            this.tickingChunks.values().removeIf(ChunkScheduler::tick);
        }
    }

    private static class SavedTickEntry {
        public final BlockPos pos;
        public final int idx;
        public final long time;

        public SavedTickEntry(CompoundNBT tag) {
            this.pos = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos"));
            this.idx = tag.func_74762_e("idx");
            this.time = tag.func_74763_f("time");
        }

        public CompoundNBT write() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
            tag.func_74768_a("idx", this.idx);
            tag.func_74772_a("time", this.time);
            return tag;
        }
    }

    private static class PartTickEntry {
        public final TMultiPart part;
        public final long time;
        public final boolean random;

        private PartTickEntry(TMultiPart part, long time, boolean random) {
            this.part = part;
            this.time = time;
            this.random = random;
        }

        public CompoundNBT write() {
            if (this.part.tile() != null) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.part.pos()));
                tag.func_74768_a("idx", this.part.tile().getPartList().indexOf(this.part));
                tag.func_74772_a("time", this.time);
                return tag;
            }
            return null;
        }
    }

    static class ChunkStorage
    implements Capability.IStorage<ChunkScheduler> {
        ChunkStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<ChunkScheduler> capability, ChunkScheduler instance, Direction side) {
            CompoundNBT tag = new CompoundNBT();
            ListNBT scheduledTicks = new ListNBT();
            instance.scheduledTicks.stream().map(PartTickEntry::write).filter(Objects::nonNull).forEach(arg_0 -> scheduledTicks.add(arg_0));
            instance.savedTicks.forEach(e -> scheduledTicks.add((Object)e.write()));
            tag.func_218657_a("ticks", (INBT)scheduledTicks);
            return tag;
        }

        public void readNBT(Capability<ChunkScheduler> capability, ChunkScheduler instance, Direction side, INBT nbt) {
            CompoundNBT tag = (CompoundNBT)nbt;
            tag.func_150295_c("ticks", 10).stream().map(e -> (CompoundNBT)e).map(SavedTickEntry::new).forEach(instance.savedTicks::add);
        }
    }

    static class ChunkScheduler {
        private final WorldTickScheduler worldScheduler;
        private final Chunk chunk;
        private final List<SavedTickEntry> savedTicks = new ArrayList<SavedTickEntry>();
        private final List<PartTickEntry> scheduledTicks = new LinkedList<PartTickEntry>();
        private final List<PartTickEntry> randomTicks = new LinkedList<PartTickEntry>();
        private boolean ticking = false;
        private final List<PartTickEntry> pendingScheduled = new LinkedList<PartTickEntry>();
        private final List<PartTickEntry> pendingRandom = new LinkedList<PartTickEntry>();

        ChunkScheduler(WorldTickScheduler worldScheduler, Chunk chunk) {
            this.worldScheduler = worldScheduler;
            this.chunk = chunk;
        }

        public void addScheduledTick(TMultiPart part, int time) {
            PartTickEntry entry = new PartTickEntry(part, this.worldScheduler.world.func_82737_E() + (long)time, false);
            if (this.ticking) {
                this.pendingScheduled.add(entry);
            } else {
                this.scheduledTicks.add(entry);
                this.onAdd();
            }
        }

        public void loadRandomTick(TMultiPart part) {
            this.addRandomTick(part, this.worldScheduler.world.func_82737_E() + (long)this.nextRandomTick());
        }

        public void addRandomTick(TMultiPart part, long time) {
            PartTickEntry entry = new PartTickEntry(part, time, true);
            if (this.ticking) {
                this.pendingRandom.add(entry);
            } else {
                this.randomTicks.add(entry);
                this.onAdd();
            }
        }

        private void onAdd() {
            if (!this.scheduledTicks.isEmpty() || !this.randomTicks.isEmpty()) {
                this.worldScheduler.tickingChunks.put(this.chunk.func_76632_l(), this);
            }
        }

        public void onChunkLoad() {
            for (SavedTickEntry savedTick : this.savedTicks) {
                TileEntity tileEntity = (TileEntity)this.chunk.func_177434_r().get(savedTick.pos);
                if (!(tileEntity instanceof TileMultiPart)) continue;
                TileMultiPart tile = (TileMultiPart)tileEntity;
                this.scheduledTicks.add(new PartTickEntry(tile.getPartList().get(savedTick.idx), savedTick.time, false));
            }
            this.savedTicks.clear();
            this.onAdd();
        }

        public boolean tick() {
            this.ticking = true;
            this.doTicks(this.scheduledTicks);
            this.doTicks(this.randomTicks);
            this.ticking = false;
            this.scheduledTicks.addAll(this.pendingScheduled);
            this.randomTicks.addAll(this.pendingRandom);
            this.pendingScheduled.clear();
            this.pendingRandom.clear();
            return this.scheduledTicks.isEmpty() && this.randomTicks.isEmpty() || !this.chunk.field_76636_d;
        }

        private void doTicks(List<PartTickEntry> list) {
            Iterator<PartTickEntry> itr = list.iterator();
            long time = this.worldScheduler.world.func_82737_E();
            while (itr.hasNext()) {
                PartTickEntry entry = itr.next();
                if (entry.time > time) continue;
                if (entry.part.tile() != null) {
                    if (entry.random) {
                        if (entry.part instanceof TRandomTickPart) {
                            ((TRandomTickPart)((Object)entry.part)).randomTick();
                        }
                        this.addRandomTick(entry.part, time + (long)this.nextRandomTick());
                    } else {
                        entry.part.scheduledTick();
                    }
                }
                itr.remove();
            }
        }

        private int nextRandomTick() {
            return this.worldScheduler.world.func_201674_k().nextInt(800) + 800;
        }
    }
}

