/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.TPartialOcclusionPart;
import codechicken.multipart.block.TileMultiPart;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

@MultiPartTrait(value=TPartialOcclusionPart.class)
public class TPartialOcclusionTile
extends TileMultiPart {
    private static TPartialOcclusionTile lastOcclusionTestedTile;
    private static VoxelShape lastOcclusionTestedShape;
    private static boolean lastOcclusionTestedResult;

    @Override
    public void bindPart(TMultiPart newPart) {
        super.bindPart(newPart);
        if (newPart instanceof TPartialOcclusionPart && lastOcclusionTestedTile == this) {
            lastOcclusionTestedTile = null;
        }
    }

    @Override
    public void partRemoved(TMultiPart remPart, int p) {
        super.partRemoved(remPart, p);
        if (remPart instanceof TPartialOcclusionPart && lastOcclusionTestedTile == this) {
            lastOcclusionTestedTile = null;
        }
    }

    @Override
    public boolean occlusionTest(Collection<TMultiPart> parts, TMultiPart npart) {
        if (npart instanceof TPartialOcclusionPart) {
            TPartialOcclusionPart newPart = (TPartialOcclusionPart)((Object)npart);
            VoxelShape newShape = newPart.getPartialOcclusionShape();
            if (lastOcclusionTestedTile != this || lastOcclusionTestedShape != newShape) {
                lastOcclusionTestedTile = this;
                lastOcclusionTestedShape = newShape;
                lastOcclusionTestedResult = TPartialOcclusionTile.partialOcclusionTest(parts, newPart);
            }
            if (!lastOcclusionTestedResult) {
                return false;
            }
        }
        return super.occlusionTest(parts, npart);
    }

    private static boolean partialOcclusionTest(Collection<TMultiPart> allParts, TPartialOcclusionPart newPart) {
        ArrayList<TPartialOcclusionPart> parts = new ArrayList<TPartialOcclusionPart>(allParts.size() + 1);
        for (TMultiPart part : allParts) {
            if (!(part instanceof TPartialOcclusionPart)) continue;
            parts.add((TPartialOcclusionPart)((Object)part));
        }
        parts.add(newPart);
        for (TPartialOcclusionPart part1 : parts) {
            if (part1.allowCompleteOcclusion()) continue;
            VoxelShape uniqueShape = part1.getPartialOcclusionShape();
            for (TPartialOcclusionPart part2 : parts) {
                if (part1 == part2) continue;
                uniqueShape = VoxelShapes.func_197878_a((VoxelShape)uniqueShape, (VoxelShape)part2.getPartialOcclusionShape(), (IBooleanFunction)IBooleanFunction.field_223234_e_);
            }
            if (!uniqueShape.func_197766_b()) continue;
            return false;
        }
        return true;
    }
}

