/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.lib.util.ArrayUtils;
import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

@MultiPartTrait.TraitList(value={@MultiPartTrait(value=IInventory.class), @MultiPartTrait(value=ISidedInventory.class)})
public class TInventoryTile
extends TileMultiPart
implements ISidedInventory {
    private List<IInventory> invList = new ArrayList<IInventory>();
    private int sizeSum = 0;
    private int[] invSize = new int[0];
    private int[][] faceSlots = (int[][])ArrayUtils.fill((Object[])new int[6][0], null);

    @Override
    public void copyFrom(TileMultiPart that) {
        super.copyFrom(that);
        if (that instanceof TInventoryTile) {
            this.invList = ((TInventoryTile)that).invList;
            this.rebuildSlotMap();
        }
    }

    @Override
    public void bindPart(TMultiPart part) {
        super.bindPart(part);
        if (part instanceof IInventory) {
            this.invList.add((IInventory)part);
            this.rebuildSlotMap();
        }
    }

    @Override
    public void partRemoved(TMultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof IInventory) {
            this.invList.remove(part);
            this.rebuildSlotMap();
        }
    }

    @Override
    public void clearParts() {
        super.clearParts();
        this.invList.clear();
        this.sizeSum = 0;
        this.invSize = new int[0];
        this.faceSlots = (int[][])ArrayUtils.fill((Object[])new int[6][0], null);
    }

    private void rebuildSlotMap() {
        this.sizeSum = this.invList.stream().mapToInt(IInventory::func_70302_i_).sum();
        this.invSize = this.invList.stream().mapToInt(IInventory::func_70302_i_).toArray();
        this.faceSlots = (int[][])ArrayUtils.fill((Object[])new int[6][0], null);
    }

    public void func_174888_l() {
        for (IInventory inv : this.invList) {
            inv.func_174888_l();
        }
    }

    public int func_70302_i_() {
        return this.sizeSum;
    }

    public boolean func_191420_l() {
        for (IInventory inv : this.invList) {
            if (inv.func_191420_l()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        return this.invList.get(i).func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        return this.invList.get(i).func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        return this.invList.get(i).func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        this.invList.get(i).func_70299_a(slot, stack);
    }

    public int[] func_180463_a(Direction side) {
        int[] slots = this.faceSlots[side.ordinal()];
        if (slots == null) {
            IntArrayList intList = new IntArrayList();
            int base = 0;
            for (IInventory inv : this.invList) {
                if (inv instanceof ISidedInventory) {
                    int finalBase = base;
                    Arrays.stream(((ISidedInventory)inv).func_180463_a(side)).map(j -> j + finalBase).forEach(arg_0 -> ((IntList)intList).add(arg_0));
                }
                base += inv.func_70302_i_();
            }
            slots = intList.toIntArray();
            this.faceSlots[side.ordinal()] = slots;
        }
        return slots;
    }

    public boolean func_180462_a(int slot, ItemStack stack, @Nullable Direction side) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        IInventory inv = this.invList.get(i);
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180462_a(slot, stack, side);
        }
        return true;
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction side) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        IInventory inv = this.invList.get(i);
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180461_b(slot, stack, side);
        }
        return true;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }
}

