/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.part.AnimateTickPart;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.ModContent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TorchPart
extends McSidedStatePart
implements AnimateTickPart {
    public static VoxelShape STANDING_OCCLUSION;
    public static VoxelShape[] WALL_OCCLUSION;

    public TorchPart() {
    }

    public TorchPart(BlockState state) {
        super(state);
    }

    @Override
    public MultiPartType<?> getType() {
        return ModContent.torchPartType;
    }

    protected Block getStandingBlock() {
        return Blocks.field_150478_aa;
    }

    protected Block getWallBlock() {
        return Blocks.field_196591_bQ;
    }

    @Override
    public BlockState defaultBlockState() {
        return this.getStandingBlock().func_176223_P();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((IItemProvider)this.getStandingBlock());
    }

    @Override
    public Direction getSide() {
        return this.state.func_177230_c() == this.getStandingBlock() ? Direction.DOWN : ((Direction)this.state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d();
    }

    @Override
    public VoxelShape getOcclusionShape() {
        if (this.state.func_177230_c() == this.getStandingBlock()) {
            return STANDING_OCCLUSION;
        }
        return WALL_OCCLUSION[this.getSide().func_176736_b()];
    }

    @Override
    public TMultiPart setStateOnPlacement(BlockItemUseContext context) {
        BlockState wallState = this.getWallBlock().func_196258_a(context);
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        for (Direction dir : context.func_196009_e()) {
            BlockState state;
            if (dir == Direction.UP) continue;
            BlockState blockState = state = dir == Direction.DOWN ? this.getStandingBlock().func_196258_a(context) : wallState;
            if (state == null || !state.func_196955_c((IWorldReader)world, pos)) continue;
            this.state = state;
            return this;
        }
        return null;
    }

    @Override
    public void animateTick(Random random) {
        this.state.func_177230_c().func_180655_c(this.state, this.world(), this.pos(), random);
    }

    static {
        WALL_OCCLUSION = new VoxelShape[4];
        STANDING_OCCLUSION = VoxelShapeCache.getShape((Cuboid6)new Cuboid6(0.4, 0.0, 0.4, 0.6, 0.6, 0.6));
        Cuboid6 wall = new Cuboid6(0.35, 0.2, 0.7, 0.65, 0.8, 1.0);
        for (int i = 0; i < 4; ++i) {
            TorchPart.WALL_OCCLUSION[i] = VoxelShapeCache.getShape((Cuboid6)wall.copy().apply(Rotation.quarterRotations[i].at(Vector3.CENTER)));
        }
    }
}

