/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.util.ArrayUtils;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.SimpleMultiPartType;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McStatePart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="minecraft")
public class ModContent {
    @ObjectHolder(value="torch")
    public static MultiPartType<TorchPart> torchPartType;
    @ObjectHolder(value="redstone_torch")
    public static MultiPartType<RedstoneTorchPart> redstoneTorchPartType;
    @ObjectHolder(value="lever")
    public static MultiPartType<LeverPart> leverPartType;
    @ObjectHolder(value="stone_button")
    public static MultiPartType<ButtonPart.StoneButtonPart> stoneButtonPartType;
    @ObjectHolder(value="oak_button")
    public static MultiPartType<ButtonPart.OakButtonPart> oakButtonPartType;
    @ObjectHolder(value="spruce_button")
    public static MultiPartType<ButtonPart.SpruceButtonPart> spruceButtonPartType;
    @ObjectHolder(value="birch_button")
    public static MultiPartType<ButtonPart.BirchButtonPart> birchButtonPartType;
    @ObjectHolder(value="jungle_button")
    public static MultiPartType<ButtonPart.JungleButtonPart> jungleButtonPartType;
    @ObjectHolder(value="acacia_button")
    public static MultiPartType<ButtonPart.AcaciaButtonPart> acaciaButtonPartType;
    @ObjectHolder(value="dark_oak_button")
    public static MultiPartType<ButtonPart.DarkOakButtonPart> darkOakButtonPartType;

    @SubscribeEvent
    public static void onRegisterMultiParts(RegistryEvent.Register<MultiPartType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        Object ext = ModLoadingContext.get().extension();
        ModLoadingContext.get().setActiveContainer(null, null);
        r.register(new SimpleMultiPartType<TorchPart>(e -> new TorchPart()).setRegistryName("torch"));
        r.register(new SimpleMultiPartType<RedstoneTorchPart>(e -> new RedstoneTorchPart()).setRegistryName("redstone_torch"));
        r.register(new SimpleMultiPartType<LeverPart>(e -> new LeverPart()).setRegistryName("lever"));
        r.register(new SimpleMultiPartType<ButtonPart.StoneButtonPart>(e -> new ButtonPart.StoneButtonPart()).setRegistryName("stone_button"));
        r.register(new SimpleMultiPartType<ButtonPart.OakButtonPart>(e -> new ButtonPart.OakButtonPart()).setRegistryName("oak_button"));
        r.register(new SimpleMultiPartType<ButtonPart.SpruceButtonPart>(e -> new ButtonPart.SpruceButtonPart()).setRegistryName("spruce_button"));
        r.register(new SimpleMultiPartType<ButtonPart.BirchButtonPart>(e -> new ButtonPart.BirchButtonPart()).setRegistryName("birch_button"));
        r.register(new SimpleMultiPartType<ButtonPart.JungleButtonPart>(e -> new ButtonPart.JungleButtonPart()).setRegistryName("jungle_button"));
        r.register(new SimpleMultiPartType<ButtonPart.AcaciaButtonPart>(e -> new ButtonPart.AcaciaButtonPart()).setRegistryName("acacia_button"));
        r.register(new SimpleMultiPartType<ButtonPart.DarkOakButtonPart>(e -> new ButtonPart.DarkOakButtonPart()).setRegistryName("dark_oak_button"));
        ModLoadingContext.get().setActiveContainer(container, ext);
    }

    @SubscribeEvent
    public static void onRegisterMultiPartConverters(RegistryEvent.Register<PartConverter> event) {
        IForgeRegistry r = event.getRegistry();
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        Object ext = ModLoadingContext.get().extension();
        ModLoadingContext.get().setActiveContainer(null, null);
        r.register(new Converter(TorchPart::new, TorchPart::new, Items.field_221657_bQ, new Block[]{Blocks.field_150478_aa, Blocks.field_196591_bQ}).setRegistryName("torch"));
        r.register(new Converter(RedstoneTorchPart::new, RedstoneTorchPart::new, Items.field_221764_cr, new Block[]{Blocks.field_150429_aA, Blocks.field_196677_cy}).setRegistryName("redstone_torch"));
        r.register(new Converter(LeverPart::new, LeverPart::new, Items.field_221746_ci, new Block[]{Blocks.field_150442_at}).setRegistryName("lever"));
        r.register(new Converter(ButtonPart.StoneButtonPart::new, ButtonPart.StoneButtonPart::new, Items.field_221766_cs, new Block[]{Blocks.field_150430_aB}).setRegistryName("stone_button"));
        r.register(new Converter(ButtonPart.OakButtonPart::new, ButtonPart.OakButtonPart::new, Items.field_221779_dZ, new Block[]{Blocks.field_196689_eF}).setRegistryName("oak_button"));
        r.register(new Converter(ButtonPart.SpruceButtonPart::new, ButtonPart.SpruceButtonPart::new, Items.field_221834_ea, new Block[]{Blocks.field_196691_eG}).setRegistryName("spruce_button"));
        r.register(new Converter(ButtonPart.BirchButtonPart::new, ButtonPart.BirchButtonPart::new, Items.field_221836_eb, new Block[]{Blocks.field_196693_eH}).setRegistryName("birch_button"));
        r.register(new Converter(ButtonPart.JungleButtonPart::new, ButtonPart.JungleButtonPart::new, Items.field_221838_ec, new Block[]{Blocks.field_196695_eI}).setRegistryName("jungle_button"));
        r.register(new Converter(ButtonPart.AcaciaButtonPart::new, ButtonPart.AcaciaButtonPart::new, Items.field_221840_ed, new Block[]{Blocks.field_196697_eJ}).setRegistryName("acacia_button"));
        r.register(new Converter(ButtonPart.DarkOakButtonPart::new, ButtonPart.DarkOakButtonPart::new, Items.field_221842_ee, new Block[]{Blocks.field_196699_eK}).setRegistryName("dark_oak_button"));
        ModLoadingContext.get().setActiveContainer(container, ext);
    }

    private static class Converter<T extends McStatePart>
    extends PartConverter {
        private final Supplier<T> factory;
        private final Function<BlockState, T> blockFactory;
        private final Item item;
        private final Block[] blocks;

        private Converter(Supplier<T> factory, Function<BlockState, T> blockFactory, Item item, Block ... blocks) {
            this.factory = factory;
            this.blockFactory = blockFactory;
            this.item = item;
            this.blocks = blocks;
        }

        @Override
        public ActionResult<Collection<TMultiPart>> convert(IWorld world, BlockPos pos, BlockState state) {
            if (this.blocks.length == 0) {
                return PartConverter.emptyResultList();
            }
            if (ArrayUtils.contains((Object[])this.blocks, (Object)state.func_177230_c())) {
                return ActionResult.func_226248_a_(Collections.singleton(this.blockFactory.apply(state)));
            }
            return super.convert(world, pos, state);
        }

        @Override
        public ActionResult<TMultiPart> convert(ItemUseContext context) {
            if (context.func_195996_i().func_77973_b() != this.item) {
                return Converter.emptyResult();
            }
            TMultiPart result = ((McStatePart)this.factory.get()).setStateOnPlacement(new BlockItemUseContext(context));
            if (result != null) {
                return ActionResult.func_226248_a_((Object)result);
            }
            return super.convert(context);
        }
    }
}

