/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.handler;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.util.CrashLock;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartNetwork;
import codechicken.multipart.util.MultiPartHelper;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class PlacementConversionHandler {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static final ThreadLocal<Object> placing = new ThreadLocal();

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, PlacementConversionHandler::onRightClickBlock);
    }

    private static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            if (placing.get() != null) {
                return;
            }
            placing.set(event);
            if (PlacementConversionHandler.place(event.getPlayer(), event.getHand(), world)) {
                event.setCanceled(true);
            }
            placing.set(null);
        }
    }

    public static boolean place(PlayerEntity player, Hand hand, World world) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b()) {
            return false;
        }
        BlockRayTraceResult hit = RayTracer.retrace((PlayerEntity)player);
        if (hit == null || hit.func_216346_c() == RayTraceResult.Type.MISS) {
            return false;
        }
        BlockPos pos = hit.func_216350_a().func_177972_a(hit.func_216354_b());
        ItemUseContext ctx = new ItemUseContext(player, hand, hit);
        TMultiPart part = MultiPartRegistries.convertItem(ctx);
        TileMultiPart tile = MultiPartHelper.getOrConvertTile(world, pos);
        if (part == null || tile == null || !tile.canAddPart(part)) {
            return false;
        }
        if (!world.field_72995_K) {
            TileMultiPart.addPart(world, pos, part);
            SoundType sound = part.getPlacementSound(ctx);
            if (sound != null) {
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
                if (held.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)held, (Hand)hand);
                }
            }
        } else {
            player.func_184609_a(hand);
            PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 10);
            packet.writeBoolean(hand == Hand.MAIN_HAND);
            packet.sendToServer();
        }
        return true;
    }
}

