/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.capability;

import codechicken.lib.util.ArrayUtils;
import java.util.Arrays;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ChainedProvider
implements ICapabilityProvider {
    public ICapabilityProvider provider;
    public ChainedProvider next;
    private Capability<?>[] seenCaps = new Capability[0];
    private LazyOptional<?>[] wrapped = new LazyOptional[0];

    public ChainedProvider(ICapabilityProvider provider) {
        this(provider, null);
    }

    public ChainedProvider(ICapabilityProvider provider, ChainedProvider next) {
        this.provider = provider;
        this.next = next;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        LazyOptional<?> ret = this.getExisting(cap);
        if (ret.isPresent()) {
            return ret.cast();
        }
        ret = this.wrap(cap, this.provider.getCapability(cap, side));
        if (ret.isPresent()) {
            return ret.cast();
        }
        return this.next != null ? this.next.getCapability(cap, side) : LazyOptional.empty();
    }

    public void append(ICapabilityProvider p) {
        if (this.next != null) {
            this.next.append(p);
        } else {
            this.next = new ChainedProvider(p);
        }
    }

    public ChainedProvider remove(ICapabilityProvider p) {
        if (this.provider == p) {
            this.invalidate(null);
            return this.next;
        }
        if (this.next != null) {
            return this.next.remove(p);
        }
        return this;
    }

    public void invalidateFor(ICapabilityProvider p) {
        if (this.provider == p) {
            this.invalidate(null);
            return;
        }
        if (this.next != null) {
            this.next.invalidateFor(p);
        }
    }

    public void invalidate(Capability<?> cap) {
        if (cap == null) {
            for (int i = 0; i < this.seenCaps.length; ++i) {
                this.seenCaps[i] = null;
                this.wrapped[i].invalidate();
                this.wrapped[i] = null;
            }
        } else {
            int idx = ArrayUtils.indexOfRef((Object[])this.seenCaps, cap);
            this.seenCaps[idx] = null;
            this.wrapped[idx].invalidate();
            this.wrapped[idx] = null;
        }
    }

    public void invalidateAll() {
        this.invalidate(null);
        if (this.next != null) {
            this.next.invalidateAll();
        }
    }

    private LazyOptional<?> wrap(Capability<?> cap, LazyOptional<?> opt) {
        if (!opt.isPresent()) {
            return LazyOptional.empty();
        }
        int idx = ArrayUtils.indexOfRef((Object[])this.seenCaps, null);
        if (idx == -1) {
            idx = this.seenCaps.length;
            this.seenCaps = Arrays.copyOf(this.seenCaps, idx + 1);
            this.wrapped = Arrays.copyOf(this.wrapped, idx + 1);
        }
        this.seenCaps[idx] = cap;
        this.wrapped[idx] = LazyOptional.of(() -> opt.orElseThrow(() -> new RuntimeException("Present but missing LazyOptional?")));
        opt.addListener(e -> this.invalidate(cap));
        return this.wrapped[idx];
    }

    private LazyOptional<?> getExisting(Capability<?> cap) {
        int idx = ArrayUtils.indexOfRef((Object[])this.seenCaps, cap);
        if (idx == -1) {
            return LazyOptional.empty();
        }
        return this.wrapped[idx];
    }
}

