/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.MethodInfo;
import codechicken.mixin.util.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Type;

public class ReflectionClassInfo
extends ClassInfo {
    private final Class<?> clazz;
    private final String name;
    private final List<ClassInfo> interfaces;
    private final List<MethodInfo> methods;

    public ReflectionClassInfo(MixinCompiler mixinCompiler, Class<?> clazz) {
        super(mixinCompiler);
        this.clazz = clazz;
        this.name = Utils.asmName(clazz.getName());
        this.interfaces = Arrays.stream(clazz.getInterfaces()).map(mixinCompiler::getClassInfo).collect(Collectors.toList());
        this.methods = Arrays.stream(clazz.getMethods()).map(x$0 -> new ReflectionMethodInfo((Method)x$0)).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public Optional<ClassInfo> getSuperClass() {
        return Optional.ofNullable(this.mixinCompiler.getClassInfo(this.clazz.getSuperclass()));
    }

    @Override
    public Stream<ClassInfo> getInterfaces() {
        return this.interfaces.stream();
    }

    @Override
    public Stream<MethodInfo> getMethods() {
        return this.methods.stream();
    }

    public class ReflectionMethodInfo
    implements MethodInfo {
        private final String name;
        private final String desc;
        private final String[] exceptions;
        private final boolean isPrivate;
        private final boolean isAbstract;

        private ReflectionMethodInfo(Method method) {
            this.name = method.getName();
            this.desc = Type.getType((Method)method).getDescriptor();
            this.exceptions = (String[])Arrays.stream(method.getExceptionTypes()).map(Class::getName).map(Utils::asmName).toArray(String[]::new);
            this.isPrivate = Modifier.isPrivate(method.getModifiers());
            this.isAbstract = Modifier.isAbstract(method.getModifiers());
        }

        @Override
        public ClassInfo getOwner() {
            return ReflectionClassInfo.this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDesc() {
            return this.desc;
        }

        @Override
        public String[] getExceptions() {
            return this.exceptions;
        }

        @Override
        public boolean isPrivate() {
            return this.isPrivate;
        }

        @Override
        public boolean isAbstract() {
            return this.isAbstract;
        }
    }
}

