/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.api;

import codechicken.mixin.MixinCompilerImpl;
import codechicken.mixin.api.MixinBackend;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.api.MixinLanguageSupport;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.MixinInfo;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.ClassNode;

public interface MixinCompiler {
    public static MixinCompiler create() {
        return new MixinCompilerImpl();
    }

    public static MixinCompiler create(MixinBackend backend) {
        return new MixinCompilerImpl(backend);
    }

    public static MixinCompiler create(MixinBackend backend, MixinDebugger debugger) {
        return new MixinCompilerImpl(backend, debugger);
    }

    public static MixinCompiler create(MixinBackend backend, MixinDebugger debugger, Collection<Class<? extends MixinLanguageSupport>> supports) {
        return new MixinCompilerImpl(backend, debugger, () -> supports);
    }

    public MixinBackend getMixinBackend();

    public <T extends MixinLanguageSupport> Optional<T> findLanguageSupport(String var1);

    @Nullable
    public ClassInfo getClassInfo(@Nullable String var1);

    @Nullable
    default public ClassInfo getClassInfo(@Nonnull ClassNode node) {
        return this.getClassInfo(node.name);
    }

    @Nullable
    default public ClassInfo getClassInfo(@Nullable Class<?> clazz) {
        return clazz == null ? null : this.getClassInfo(clazz.getName().replace(".", "/"));
    }

    @Nullable
    public ClassNode getClassNode(@Nonnull String var1);

    public MixinInfo registerTrait(ClassNode var1);

    @Nullable
    public MixinInfo getMixinInfo(String var1);

    public void defineInternal(String var1, byte[] var2);

    @Nonnull
    public <T> Class<T> defineClass(String var1, byte[] var2);

    public <T> Class<T> compileMixinClass(String var1, String var2, Set<String> var3);
}

