/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.api;

import codechicken.mixin.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public interface MixinBackend {
    @Nullable
    public byte[] getBytes(String var1);

    @Nonnull
    public <T> Class<T> defineClass(String var1, byte[] var2);

    public Class<?> loadClass(String var1);

    default public boolean filterMethodAnnotations(String annType, String value) {
        return true;
    }

    public static class SimpleMixinBackend
    implements MixinBackend {
        protected static final MethodHandle m_defineClass;
        private final ClassLoader classLoader;

        public SimpleMixinBackend() {
            this(SimpleMixinBackend.class.getClassLoader());
        }

        public SimpleMixinBackend(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] getBytes(String name) {
            try (InputStream is = this.classLoader.getResourceAsStream(name + ".class");){
                if (is == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                byte[] byArray = IOUtils.toByteArray((InputStream)is);
                return byArray;
            }
            catch (IOException e) {
                Utils.throwUnchecked(new ClassNotFoundException("Could not load bytes for '" + name + "'.", e));
                return null;
            }
        }

        @Override
        public <T> Class<T> defineClass(String name, byte[] bytes) {
            try {
                return m_defineClass.invoke(this.classLoader, bytes, 0, bytes.length);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to define class '" + name + "'.", e);
            }
        }

        @Override
        public Class<?> loadClass(String name) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Method m = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE);
                m.setAccessible(true);
                m_defineClass = lookup.unreflect(m);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to retrieve methods via reflection.", e);
            }
        }
    }
}

