/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin;

import codechicken.asm.ASMHelper;
import codechicken.mixin.api.MixinBackend;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.api.MixinLanguageSupport;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.FieldMixin;
import codechicken.mixin.util.MethodInfo;
import codechicken.mixin.util.MixinInfo;
import codechicken.mixin.util.SimpleServiceLoader;
import codechicken.mixin.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class MixinCompilerImpl
implements MixinCompiler {
    public static final Level LOG_LEVEL = Level.getLevel((String)System.getProperty("codechicken.mixin.log_level", "DEBUG"));
    private static final Logger logger = LogManager.getLogger((String)"CodeChicken/MixinCompiler");
    private final MixinBackend mixinBackend;
    private final MixinDebugger debugger;
    private final List<MixinLanguageSupport> languageSupportList;
    private final Map<String, MixinLanguageSupport> languageSupportMap;
    private final Map<String, byte[]> traitByteMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, ClassInfo> infoCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, MixinInfo> mixinMap = Collections.synchronizedMap(new HashMap());

    public MixinCompilerImpl() {
        this(new MixinBackend.SimpleMixinBackend());
    }

    public MixinCompilerImpl(MixinBackend mixinBackend) {
        this(mixinBackend, new MixinDebugger.NullDebugger());
    }

    public MixinCompilerImpl(MixinBackend mixinBackend, MixinDebugger debugger) {
        this(mixinBackend, debugger, () -> new SimpleServiceLoader<MixinLanguageSupport>(MixinLanguageSupport.class).poll().getNewServices());
    }

    public MixinCompilerImpl(MixinBackend mixinBackend, MixinDebugger debugger, Supplier<Collection<Class<? extends MixinLanguageSupport>>> supportSupplier) {
        this.mixinBackend = mixinBackend;
        this.debugger = debugger;
        logger.log(LOG_LEVEL, "Starting CodeChicken MixinCompiler.");
        logger.log(LOG_LEVEL, "Loading MixinLanguageSupport services..");
        long start = System.nanoTime();
        List languageSupportInstances = supportSupplier.get().stream().map(x$0 -> new LanguageSupportInstance((Class<? extends MixinLanguageSupport>)x$0)).sorted(Comparator.comparingInt(e -> ((LanguageSupportInstance)e).sortIndex)).collect(Collectors.toList());
        this.languageSupportList = languageSupportInstances.stream().map(e -> ((LanguageSupportInstance)e).instance).collect(Collectors.toList());
        HashMap<String, LanguageSupportInstance> languageSupportInstanceMap = new HashMap<String, LanguageSupportInstance>();
        for (LanguageSupportInstance instance : languageSupportInstances) {
            LanguageSupportInstance other = (LanguageSupportInstance)languageSupportInstanceMap.get(instance.name);
            if (other != null) {
                throw new RuntimeException(String.format("Duplicate MixinLanguageSupport. '%s' name conflicts with '%s'", instance, other));
            }
            languageSupportInstanceMap.put(instance.name, instance);
        }
        this.languageSupportMap = languageSupportInstanceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LanguageSupportInstance)e.getValue()).instance));
        long end = System.nanoTime();
        logger.log(LOG_LEVEL, "Loaded {} MixinLanguageSupport instances in {}.", (Object)this.languageSupportList.size(), (Object)Utils.timeString(start, end));
    }

    @Override
    public MixinBackend getMixinBackend() {
        return this.mixinBackend;
    }

    @Override
    public <T extends MixinLanguageSupport> Optional<T> findLanguageSupport(String name) {
        return Optional.ofNullable(this.languageSupportMap.get(name));
    }

    @Override
    public ClassInfo getClassInfo(String name) {
        ClassInfo info = this.infoCache.get(name);
        if (info == null) {
            info = this.obtainInfo(name);
            this.infoCache.put(name, info);
        }
        return info;
    }

    @Override
    public MixinInfo getMixinInfo(String name) {
        return this.mixinMap.get(name);
    }

    @Override
    public <T> Class<T> compileMixinClass(String name, String superClass, Set<String> traits) {
        ClassInfo baseInfo = this.getClassInfo(superClass);
        if (traits.isEmpty()) {
            return this.mixinBackend.loadClass(baseInfo.getName().replace('/', '.'));
        }
        long start = System.nanoTime();
        List baseTraits = traits.stream().map(this.mixinMap::get).collect(Collectors.toList());
        List mixinInfos = baseTraits.stream().flatMap(MixinInfo::linearize).distinct().collect(Collectors.toList());
        List traitInfos = mixinInfos.stream().map(MixinInfo::getName).map(this::getClassInfo).collect(Collectors.toList());
        ClassNode cNode = new ClassNode();
        cNode.visit(52, 1, name, null, superClass, (String[])baseTraits.stream().map(MixinInfo::getName).toArray(String[]::new));
        MethodInfo cInit = baseInfo.getMethods().filter(e -> e.getName().equals("<init>")).findFirst().orElseThrow(IllegalStateException::new);
        MethodNode mInit = (MethodNode)cNode.visitMethod(1, "<init>", cInit.getDesc(), null, null);
        Utils.writeBridge((MethodVisitor)mInit, cInit.getDesc(), 183, superClass, "<init>", cInit.getDesc(), false);
        mInit.instructions.remove(mInit.instructions.getLast());
        ArrayList<Object> prevInfos = new ArrayList<Object>();
        for (Object t : mixinInfos) {
            mInit.visitVarInsn(25, 0);
            mInit.visitMethodInsn(184, ((MixinInfo)t).getName(), "$init$", "(L" + ((MixinInfo)t).getName() + ";)V", true);
            for (FieldMixin fieldMixin : ((MixinInfo)t).getFields()) {
                FieldNode fv = (FieldNode)cNode.visitField(2, fieldMixin.getAccessName(((MixinInfo)t).getName()), fieldMixin.getDesc(), null, null);
                Type fType = Type.getType((String)fv.desc);
                MethodVisitor mv = cNode.visitMethod(1, fv.name, "()" + fieldMixin.getDesc(), null, null);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, name, fv.name, fv.desc);
                mv.visitInsn(fType.getOpcode(172));
                mv.visitMaxs(-1, -1);
                mv = cNode.visitMethod(1, fv.name + "_$eq", "(" + fieldMixin.getDesc() + ")V", null, null);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(fType.getOpcode(21), 1);
                mv.visitFieldInsn(181, name, fv.name, fv.desc);
                mv.visitInsn(177);
                mv.visitMaxs(-1, -1);
            }
            for (String string : ((MixinInfo)t).getSupers()) {
                int nIdx = string.indexOf(40);
                String sName = string.substring(0, nIdx);
                String sDesc = string.substring(nIdx);
                MethodNode mv = (MethodNode)cNode.visitMethod(1, ((MixinInfo)t).getName().replace("/", "$") + "$$super$" + sName, sDesc, null, null);
                Optional<MixinInfo> prev = Lists.reverse(prevInfos).stream().filter(e -> e.getMethods().stream().anyMatch(m -> m.name.equals(sName) && m.desc.equals(sDesc))).findFirst();
                if (prev.isPresent()) {
                    Utils.writeStaticBridge(mv, sName, prev.get());
                    continue;
                }
                MethodInfo mInfo = baseInfo.findPublicImpl(sName, sDesc).orElseThrow(IllegalStateException::new);
                Utils.writeBridge((MethodVisitor)mv, sDesc, 183, mInfo.getOwner().getName(), sName, sDesc, mInfo.getOwner().isInterface());
            }
            prevInfos.add(t);
        }
        mInit.visitInsn(177);
        HashSet<String> methodSigs = new HashSet<String>();
        for (MixinInfo t : Lists.reverse(mixinInfos)) {
            for (MethodNode m2 : t.getMethods()) {
                if (!methodSigs.add(m2.name + m2.desc)) continue;
                MethodNode mv = (MethodNode)cNode.visitMethod(1, m2.name, m2.desc, null, m2.exceptions.toArray(new String[0]));
                Utils.writeStaticBridge(mv, m2.name, t);
            }
        }
        Set allParentInfos = Utils.of(baseInfo, traitInfos).stream().flatMap(Utils::allParents).collect(Collectors.toSet());
        List allParentMethods = allParentInfos.stream().flatMap(ClassInfo::getMethods).collect(Collectors.toList());
        for (String nameDesc : new HashSet(methodSigs)) {
            int nIdx = nameDesc.indexOf(40);
            String sName = nameDesc.substring(0, nIdx);
            String sDesc = nameDesc.substring(nIdx);
            String pDesc = sDesc.substring(0, sDesc.lastIndexOf(")") + 1);
            allParentMethods.stream().filter(m -> m.getName().equals(sName) && m.getDesc().startsWith(pDesc)).forEach(m -> {
                if (methodSigs.add(m.getName() + m.getDesc())) {
                    MethodNode mv = (MethodNode)cNode.visitMethod(4161, m.getName(), m.getDesc(), null, m.getExceptions());
                    Utils.writeBridge((MethodVisitor)mv, mv.desc, 182, cNode.name, sName, sDesc, (cNode.access & 0x200) != 0);
                }
            });
        }
        byte[] byArray = ASMHelper.createBytes(cNode, 3);
        long end = System.nanoTime();
        logger.log(LOG_LEVEL, "Generation of {} with [{}] took {}", (Object)superClass, (Object)String.join((CharSequence)", ", traits), (Object)Utils.timeString(start, end));
        return this.defineClass(name, byArray);
    }

    @Override
    public void defineInternal(String name, byte[] bytes) {
        String asmName = Utils.asmName(name);
        this.traitByteMap.put(asmName, bytes);
        this.infoCache.remove(asmName);
        this.debugger.defineInternal(name, bytes);
    }

    @Override
    public <T> Class<T> defineClass(String name, byte[] bytes) {
        String asmName = Utils.asmName(name);
        this.defineInternal(asmName, bytes);
        this.debugger.defineClass(name, bytes);
        return this.mixinBackend.defineClass(name, bytes);
    }

    @Override
    public MixinInfo registerTrait(ClassNode cNode) {
        MixinInfo info = this.mixinMap.get(cNode.name);
        if (info != null) {
            return info;
        }
        for (MixinLanguageSupport languageSupport : this.languageSupportList) {
            Optional<MixinInfo> opt = languageSupport.buildMixinTrait(cNode);
            if (!opt.isPresent()) continue;
            info = opt.get();
            if (!cNode.name.equals(info.getName())) {
                throw new IllegalStateException("Traits must have the same name as their ClassNode. Got: " + info.getName() + ", Expected: " + cNode.name);
            }
            this.mixinMap.put(info.getName(), info);
            return info;
        }
        throw new IllegalStateException("No MixinLanguageSupport wished to handle class '" + cNode.name + "'");
    }

    private ClassInfo obtainInfo(String name) {
        if (name == null) {
            return null;
        }
        ClassNode cNode = this.getClassNode(name);
        for (MixinLanguageSupport languageSupport : this.languageSupportList) {
            Optional<ClassInfo> info = languageSupport.obtainInfo(name, cNode);
            if (!info.isPresent()) continue;
            return info.get();
        }
        return null;
    }

    @Override
    public ClassNode getClassNode(String name) {
        if (name.equals("java/lang/Object")) {
            return null;
        }
        byte[] bytes = this.traitByteMap.computeIfAbsent(name, this.mixinBackend::getBytes);
        if (bytes == null) {
            return null;
        }
        return ASMHelper.createClassNode(bytes, 8);
    }

    private class LanguageSupportInstance {
        private final Class<? extends MixinLanguageSupport> clazz;
        private final MixinLanguageSupport instance;
        private final String name;
        private final int sortIndex;

        public LanguageSupportInstance(Class<? extends MixinLanguageSupport> clazz) {
            this.clazz = clazz;
            MixinLanguageSupport.LanguageName lName = clazz.getAnnotation(MixinLanguageSupport.LanguageName.class);
            MixinLanguageSupport.SortingIndex sIndex = clazz.getAnnotation(MixinLanguageSupport.SortingIndex.class);
            if (lName == null) {
                throw new RuntimeException("MixinLanguageSupport '" + clazz.getName() + "' is not annotated with MixinLanguageSupport.LanguageName!");
            }
            this.name = lName.value();
            this.sortIndex = sIndex != null ? sIndex.value() : 1000;
            logger.log(LOG_LEVEL, "Loading MixinLanguageSupport '{}', Name: '{}', Sorting Index: '{}'", (Object)clazz.getName(), (Object)this.name, (Object)this.sortIndex);
            Optional<MixinLanguageSupport> instance = Utils.findConstructor(clazz, MixinCompiler.class).map(c -> (MixinLanguageSupport)Utils.newInstance(c, MixinCompilerImpl.this));
            this.instance = instance.orElseGet(() -> Utils.findConstructor(clazz, new Class[0]).map(x$0 -> (MixinLanguageSupport)Utils.newInstance(x$0, new Object[0])).orElseThrow(RuntimeException::new));
        }

        public String toString() {
            return new StringJoiner(", ", LanguageSupportInstance.class.getSimpleName() + "[", "]").add("class=" + this.clazz.getName()).add("name='" + this.name + "'").add("sortIndex=" + this.sortIndex).toString();
        }
    }
}

