/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class RenderLayerHandler {
    private static final Map<Block, RenderTypeSkeleton> mapping = new HashMap<Block, RenderTypeSkeleton>();
    private static final Map<Block, Block> inheritances = new HashMap<Block, Block>();
    @OnlyIn(value=Dist.CLIENT)
    private static Map<RenderTypeSkeleton, RenderType> renderTypes;

    public static void setRenderType(Block block, RenderTypeSkeleton skeleton) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderLayerHandler.setRenderTypeClient(block, skeleton));
    }

    public static void setInherited(Block block, Block parent) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderLayerHandler.setInheritedClient(block, parent));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        for (Block b : inheritances.keySet()) {
            Block inherit = inheritances.get(b);
            if (!mapping.containsKey(inherit)) continue;
            mapping.put(b, mapping.get(inherit));
        }
        for (Block b : mapping.keySet()) {
            RenderTypeLookup.setRenderLayer((Block)b, (RenderType)renderTypes.get((Object)mapping.get(b)));
        }
        inheritances.clear();
        mapping.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setRenderTypeClient(Block block, RenderTypeSkeleton skeleton) {
        RenderLayerHandler.resolveRenderTypes();
        mapping.put(block, skeleton);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setInheritedClient(Block block, Block parent) {
        RenderLayerHandler.resolveRenderTypes();
        inheritances.put(block, parent);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void resolveRenderTypes() {
        if (renderTypes == null) {
            renderTypes = new HashMap<RenderTypeSkeleton, RenderType>();
            renderTypes.put(RenderTypeSkeleton.SOLID, RenderType.func_228639_c_());
            renderTypes.put(RenderTypeSkeleton.CUTOUT, RenderType.func_228643_e_());
            renderTypes.put(RenderTypeSkeleton.CUTOUT_MIPPED, RenderType.func_228641_d_());
            renderTypes.put(RenderTypeSkeleton.TRANSLUCENT, RenderType.func_228645_f_());
        }
    }

    public static enum RenderTypeSkeleton {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

