/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.addons.oddities.block.MovingMagnetizedBlock;
import vazkii.quark.addons.oddities.magnetsystem.MagnetSystem;
import vazkii.quark.addons.oddities.module.MagnetsModule;
import vazkii.quark.addons.oddities.tile.MagnetTileEntity;
import vazkii.quark.addons.oddities.tile.MagnetizedBlockTileEntity;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;

public class MagnetBlock
extends QuarkBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public MagnetBlock(QuarkModule module) {
        super("magnet", module, ItemGroup.field_78028_d, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (stack.func_200301_q().func_150261_e().equals("Q")) {
            tooltip.add((ITextComponent)new StringTextComponent("haha yes"));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        boolean wasPowered = (Boolean)state.func_177229_b((Property)POWERED);
        boolean isPowered = this.isPowered(worldIn, pos, (Direction)state.func_177229_b((Property)FACING));
        if (isPowered != wasPowered) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)));
        }
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int action, int data) {
        boolean push = action == 0;
        Direction moveDir = (Direction)state.func_177229_b((Property)FACING);
        Direction dir = push ? moveDir : moveDir.func_176734_d();
        BlockPos targetPos = pos.func_177967_a(dir, data);
        BlockState targetState = world.func_180495_p(targetPos);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof MagnetTileEntity)) {
            return false;
        }
        BlockPos endPos = targetPos.func_177972_a(moveDir);
        PushReaction reaction = MagnetSystem.getPushAction((MagnetTileEntity)tile, targetPos, targetState, moveDir);
        if (reaction != PushReaction.IGNORE && reaction != PushReaction.DESTROY) {
            return false;
        }
        TileEntity tilePresent = world.func_175625_s(targetPos);
        CompoundNBT tileData = new CompoundNBT();
        if (tilePresent != null && !(tilePresent instanceof MagnetizedBlockTileEntity)) {
            tilePresent.func_189515_b(tileData);
        }
        MagnetizedBlockTileEntity movingTile = new MagnetizedBlockTileEntity(targetState, tileData, moveDir);
        if (!world.field_72995_K && reaction == PushReaction.DESTROY) {
            BlockState blockstate = world.func_180495_p(endPos);
            Block.func_220059_a((BlockState)blockstate, (IWorld)world, (BlockPos)endPos, (TileEntity)tilePresent);
        }
        if (tilePresent != null) {
            tilePresent.func_145843_s();
        }
        world.func_180501_a(endPos, (BlockState)MagnetsModule.magnetized_block.func_176223_P().func_206870_a((Property)MovingMagnetizedBlock.FACING, (Comparable)moveDir), 68);
        world.func_175690_a(endPos, (TileEntity)movingTile);
        world.func_180501_a(targetPos, Blocks.field_150350_a.func_176223_P(), 66);
        return true;
    }

    private boolean isPowered(World worldIn, BlockPos pos, Direction facing) {
        Direction opp = facing.func_176734_d();
        for (Direction direction : Direction.values()) {
            if (direction == facing || direction == opp || !worldIn.func_175709_b(pos.func_177972_a(direction), direction)) continue;
            return true;
        }
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196010_d().func_176734_d();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(this.isPowered(context.func_195991_k(), context.func_195995_a(), facing)));
    }

    @Nonnull
    public BlockState func_185499_a(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MagnetTileEntity();
    }
}

