/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.shader.FogMode;
import com.jozufozu.flywheel.core.shader.extension.IExtensionInstance;
import com.jozufozu.flywheel.core.shader.extension.IProgramExtension;
import com.jozufozu.flywheel.core.shader.extension.UnitExtensionInstance;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public enum WorldFog implements IProgramExtension
{
    NONE("none", UnitExtensionInstance::new),
    LINEAR("linear", FogMode.Linear::new),
    EXP2("exp2", FogMode.Exp2::new);

    private final ResourceLocation id;
    private final String name;
    private final Function<GlProgram, IExtensionInstance> fogFactory;

    private WorldFog(String name, Function<GlProgram, IExtensionInstance> fogFactory) {
        this.id = new ResourceLocation("flywheel", "fog_" + name);
        this.name = name;
        this.fogFactory = fogFactory;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public IExtensionInstance create(GlProgram program) {
        return this.fogFactory.apply(program);
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }
}

