/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.customgamerules.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeverBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class UtilWorld {
    public static String dimensionToString(World w) {
        return w.func_234923_W_().getRegistryName().toString();
    }

    public static double distanceBetweenHorizontal(BlockPos start, BlockPos end) {
        int xDistance = Math.abs(start.func_177958_n() - end.func_177958_n());
        int zDistance = Math.abs(start.func_177952_p() - end.func_177952_p());
        return Math.sqrt(xDistance * xDistance + zDistance * zDistance);
    }

    public static BlockPos nextReplaceableInDirection(World world, BlockPos posIn, Direction facing, int max, @Nullable Block blockMatch) {
        BlockPos posToPlaceAt = new BlockPos((Vector3i)posIn);
        BlockPos posLoop = new BlockPos((Vector3i)posIn);
        for (int i = 0; i < max; ++i) {
            BlockState state = world.func_180495_p(posLoop);
            if (state.func_177230_c() != null && world.func_180495_p(posLoop).func_177230_c() == Blocks.field_150350_a) {
                posToPlaceAt = posLoop;
                break;
            }
            posLoop = posLoop.func_177972_a(facing);
        }
        return posToPlaceAt;
    }

    public static ItemEntity dropItemStackInWorld(World world, BlockPos pos, ItemStack stack) {
        if (pos == null || world == null || stack.func_190926_b()) {
            return null;
        }
        ItemEntity entityItem = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)entityItem);
        }
        return entityItem;
    }

    public static BlockPos getRandomPos(Random rand, BlockPos here, int hRadius) {
        int x = here.func_177958_n();
        int z = here.func_177952_p();
        int xMin = x - hRadius;
        int xMax = x + hRadius;
        int zMin = z - hRadius;
        int zMax = z + hRadius;
        int posX = MathHelper.func_76136_a((Random)rand, (int)xMin, (int)xMax);
        int posZ = MathHelper.func_76136_a((Random)rand, (int)zMin, (int)zMax);
        return new BlockPos(posX, here.func_177956_o(), posZ);
    }

    public static ArrayList<BlockPos> findBlocks(World world, BlockPos start, Block blockHunt, int RADIUS) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        int xMin = start.func_177958_n() - RADIUS;
        int xMax = start.func_177958_n() + RADIUS;
        int yMin = start.func_177956_o() - RADIUS;
        int yMax = start.func_177956_o() + RADIUS;
        int zMin = start.func_177952_p() - RADIUS;
        int zMax = start.func_177952_p() + RADIUS;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!world.func_180495_p(posCurrent).func_177230_c().equals(blockHunt)) continue;
                    found.add(posCurrent);
                }
            }
        }
        return found;
    }

    public static void toggleLeverPowerState(World worldIn, BlockPos blockPos, BlockState blockState) {
        boolean hasPowerHere = (Boolean)blockState.func_177229_b((Property)LeverBlock.field_176359_b);
        BlockState stateNew = (BlockState)blockState.func_206870_a((Property)LeverBlock.field_176359_b, (Comparable)Boolean.valueOf(!hasPowerHere));
        boolean success = worldIn.func_175656_a(blockPos, stateNew);
        if (success) {
            UtilWorld.flagUpdate(worldIn, blockPos, blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.func_177977_b(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.func_177984_a(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.func_177976_e(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.func_177974_f(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.func_177978_c(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.func_177968_d(), blockState, stateNew);
        }
    }

    public static void flagUpdate(World worldIn, BlockPos blockPos, BlockState blockState, BlockState stateNew) {
        worldIn.func_184138_a(blockPos, blockState, stateNew, 3);
        worldIn.func_195593_d(blockPos, stateNew.func_177230_c());
        worldIn.func_195593_d(blockPos, blockState.func_177230_c());
    }

    public static BlockPos findClosestBlock(PlayerEntity player, Block blockHunt, int RADIUS) {
        BlockPos found = null;
        int xMin = (int)player.func_226277_ct_() - RADIUS;
        int xMax = (int)player.func_226277_ct_() + RADIUS;
        int yMin = (int)player.func_226278_cu_() - RADIUS;
        int yMax = (int)player.func_226278_cu_() + RADIUS;
        int zMin = (int)player.func_226281_cx_() - RADIUS;
        int zMax = (int)player.func_226281_cx_() + RADIUS;
        int distance = 0;
        int distanceClosest = RADIUS * RADIUS;
        BlockPos posCurrent = null;
        World world = player.func_130014_f_();
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!world.isAreaLoaded(posCurrent, 1) || !world.func_180495_p(posCurrent).func_177230_c().equals(blockHunt)) continue;
                    if (found == null) {
                        found = posCurrent;
                        continue;
                    }
                    distance = (int)UtilWorld.distanceBetweenHorizontal(player.func_233580_cy_(), posCurrent);
                    if (distance >= distanceClosest) continue;
                    found = posCurrent;
                    distanceClosest = distance;
                }
            }
        }
        return found;
    }

    public static List<BlockPos> getPositionsInRange(BlockPos pos, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    found.add(new BlockPos(x, y, z));
                }
            }
        }
        return found;
    }

    public static boolean doBlockStatesMatch(BlockState replacedBlockState, BlockState newToPlace) {
        return replacedBlockState.equals(newToPlace);
    }
}

