/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.customgamerules;

import com.lothrazar.customgamerules.GameRuleMod;
import com.lothrazar.customgamerules.PacketHungerRuleSync;
import com.lothrazar.customgamerules.util.RuleFactory;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class RuleRegistry {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("customgamerules", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static GameRules.RuleKey<GameRules.BooleanValue> disableBiomeFreezeIce;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableBlockGravity;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableDecayCoral;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableDecayLeaves;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableFarmlandTrampling;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableGenerateObsidian;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableGenerateStone;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableLightMeltIce;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableMobItemPickup;
    public static GameRules.RuleKey<GameRules.BooleanValue> disablePetFriendlyFire;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableVillagerTrading;
    public static GameRules.RuleKey<GameRules.BooleanValue> doArmorStandWeapons;
    public static GameRules.RuleKey<GameRules.BooleanValue> doLilypadsBreak;
    public static GameRules.RuleKey<GameRules.BooleanValue> doEyesAlwaysBreak;
    public static GameRules.RuleKey<GameRules.BooleanValue> doCactusGrowthUnlimited;
    public static GameRules.RuleKey<GameRules.BooleanValue> doInstantEating;
    public static GameRules.RuleKey<GameRules.BooleanValue> doInstantExp;
    public static GameRules.RuleKey<GameRules.BooleanValue> doNetherVoidAbove;
    public static GameRules.RuleKey<GameRules.BooleanValue> doMapsAlwaysUpdate;
    public static GameRules.RuleKey<GameRules.BooleanValue> doSugarGrowthUnlimited;
    public static GameRules.RuleKey<GameRules.BooleanValue> suffocationDamage;
    public static GameRules.RuleKey<GameRules.BooleanValue> pearlDamage;
    public static GameRules.RuleKey<GameRules.BooleanValue> cactusDamage;
    public static GameRules.RuleKey<GameRules.BooleanValue> berryDamage;
    public static GameRules.RuleKey<GameRules.BooleanValue> keepInventoryExperience;
    public static GameRules.RuleKey<GameRules.BooleanValue> keepInventoryArmor;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingCreeper;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingEnderman;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingVillager;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingZombie;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingWither;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingRavager;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingGhast;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingSilverfish;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingBlaze;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableEndermanTeleport;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableShulkerTeleport;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableCropGrowth;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableSaplingGrowth;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableCriticalHits;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableHunger;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableTargetingPlayers;
    public static GameRules.RuleKey<GameRules.BooleanValue> disableLightningTransform;
    public static GameRules.RuleKey<GameRules.BooleanValue> disablePortalCreationNether;
    public static GameRules.RuleKey<GameRules.BooleanValue> disablePortalCreationEnd;
    public static GameRules.RuleKey<GameRules.BooleanValue> mobGriefingSnowgolem;
    public static GameRules.RuleKey<GameRules.BooleanValue> doFriendlyIronGolems;

    public static void setup() {
        int id = 0;
        INSTANCE.registerMessage(id++, PacketHungerRuleSync.class, PacketHungerRuleSync::encode, PacketHungerRuleSync::decode, PacketHungerRuleSync::handle);
        suffocationDamage = RuleFactory.createBoolean("suffocationDamage", true, GameRules.Category.PLAYER);
        pearlDamage = RuleFactory.createBoolean("pearlDamage", true, GameRules.Category.PLAYER);
        cactusDamage = RuleFactory.createBoolean("cactusDamage", true, GameRules.Category.PLAYER);
        berryDamage = RuleFactory.createBoolean("berryDamage", true, GameRules.Category.PLAYER);
        keepInventoryExperience = RuleFactory.createBoolean("keepInventoryExperience", false, GameRules.Category.PLAYER);
        keepInventoryArmor = RuleFactory.createBoolean("keepInventoryArmor", false, GameRules.Category.PLAYER);
        doFriendlyIronGolems = RuleFactory.createBoolean("doFriendlyIronGolems", true, GameRules.Category.MOBS);
        doMapsAlwaysUpdate = RuleFactory.createBoolean("doMapsAlwaysUpdate", true, GameRules.Category.PLAYER);
        doLilypadsBreak = RuleFactory.createBoolean("doLilypadsBreak", true, GameRules.Category.PLAYER);
        doInstantEating = RuleFactory.createBoolean("doInstantEating", false, GameRules.Category.PLAYER);
        doInstantExp = RuleFactory.createBoolean("doInstantExp", false, GameRules.Category.PLAYER);
        doArmorStandWeapons = RuleFactory.createBoolean("doArmorStandWeapons", true, GameRules.Category.PLAYER);
        doEyesAlwaysBreak = RuleFactory.createBoolean("doEyesAlwaysBreak", false, GameRules.Category.DROPS);
        doNetherVoidAbove = RuleFactory.createBoolean("doNetherVoidAbove", false, GameRules.Category.MISC);
        doCactusGrowthUnlimited = RuleFactory.createBoolean("doCactusGrowthUnlimited", false, GameRules.Category.MISC);
        doSugarGrowthUnlimited = RuleFactory.createBoolean("doSugarGrowthUnlimited", false, GameRules.Category.MISC);
        disablePortalCreationEnd = RuleFactory.createBoolean("disablePortalCreationEnd", false, GameRules.Category.PLAYER);
        disablePortalCreationNether = RuleFactory.createBoolean("disablePortalCreationNether", false, GameRules.Category.PLAYER);
        disableLightningTransform = RuleFactory.createBoolean("disableLightningTransform", false, GameRules.Category.MOBS);
        disableTargetingPlayers = RuleFactory.createBoolean("disableTargetingPlayers", false, GameRules.Category.MOBS);
        disableVillagerTrading = RuleFactory.createBoolean("disableVillagerTrading", false, GameRules.Category.MOBS);
        disableBlockGravity = RuleFactory.createBoolean("disableBlockGravity", false, GameRules.Category.UPDATES);
        disableBiomeFreezeIce = RuleFactory.createBoolean("disableBiomeFreezeIce", false, GameRules.Category.UPDATES);
        disableLightMeltIce = RuleFactory.createBoolean("disableLightMeltIce", false, GameRules.Category.UPDATES);
        disableDecayLeaves = RuleFactory.createBoolean("disableDecayLeaves", false, GameRules.Category.UPDATES);
        disableDecayCoral = RuleFactory.createBoolean("disableDecayCoral", false, GameRules.Category.UPDATES);
        disableGenerateStone = RuleFactory.createBoolean("disableGenerateStone", false, GameRules.Category.UPDATES);
        disableGenerateObsidian = RuleFactory.createBoolean("disableGenerateObsidian", false, GameRules.Category.UPDATES);
        disablePetFriendlyFire = RuleFactory.createBoolean("disablePetFriendlyFire", true, GameRules.Category.UPDATES);
        disableFarmlandTrampling = RuleFactory.createBoolean("disableFarmlandTrampling", false, GameRules.Category.UPDATES);
        disableMobItemPickup = RuleFactory.createBoolean("disableMobItemPickup", false, GameRules.Category.MOBS);
        disableEndermanTeleport = RuleFactory.createBoolean("disableEndermanTeleport", false, GameRules.Category.MOBS);
        disableShulkerTeleport = RuleFactory.createBoolean("disableShulkerTeleport", false, GameRules.Category.MOBS);
        disableCropGrowth = RuleFactory.createBoolean("disableCropGrowth", false, GameRules.Category.UPDATES);
        disableSaplingGrowth = RuleFactory.createBoolean("disableSaplingGrowth", false, GameRules.Category.UPDATES);
        disableCriticalHits = RuleFactory.createBoolean("disableCriticalHits", false, GameRules.Category.UPDATES);
        disableHunger = RuleFactory.createBoolean("disableHunger", false, GameRules.Category.PLAYER);
        mobGriefingCreeper = RuleFactory.createBoolean("mobGriefingCreeper", true, GameRules.Category.MOBS);
        mobGriefingEnderman = RuleFactory.createBoolean("mobGriefingEnderman", true, GameRules.Category.MOBS);
        mobGriefingVillager = RuleFactory.createBoolean("mobGriefingVillager", true, GameRules.Category.MOBS);
        mobGriefingZombie = RuleFactory.createBoolean("mobGriefingZombie", true, GameRules.Category.MOBS);
        mobGriefingWither = RuleFactory.createBoolean("mobGriefingWither", true, GameRules.Category.MOBS);
        mobGriefingRavager = RuleFactory.createBoolean("mobGriefingRavager", true, GameRules.Category.MOBS);
        mobGriefingSilverfish = RuleFactory.createBoolean("mobGriefingSilverfish", true, GameRules.Category.MOBS);
        mobGriefingGhast = RuleFactory.createBoolean("mobGriefingGhast", true, GameRules.Category.MOBS);
        mobGriefingBlaze = RuleFactory.createBoolean("mobGriefingBlaze", true, GameRules.Category.MOBS);
        mobGriefingSnowgolem = RuleFactory.createBoolean("mobGriefingSnowgolem", true, GameRules.Category.MOBS);
        GameRuleMod.LOGGER.info("customgamerules has added " + RuleFactory.count + " gamerules");
    }

    public static boolean isEnabled(World world, GameRules.RuleKey<GameRules.BooleanValue> key) {
        return world.func_82736_K().func_223586_b(key);
    }

    public static boolean isEnabled(IWorld world, GameRules.RuleKey<GameRules.BooleanValue> key) {
        if (!(world instanceof World)) {
            return false;
        }
        return ((World)world).func_82736_K().func_223586_b(key);
    }

    public static void sendToAllClients(World world, PacketHungerRuleSync packet) {
        for (PlayerEntity player : world.func_217369_A()) {
            if (!(player instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity sp = (ServerPlayerEntity)player;
            INSTANCE.sendTo((Object)packet, sp.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

