/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.client.renderer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.RenderContext;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.util.HackyTextComponentNBT;

@OnlyIn(value=Dist.CLIENT)
public class BoxTooltipRenderer
implements ITooltipRenderer {
    private final Cache<CompoundNBT, Tooltip> cachedTooltips = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private static Field FIELD_SIZE;

    @Override
    public Dimension getSize(CompoundNBT nbt, ICommonAccessor accessor) {
        Tooltip tooltip = this.geTooltip(nbt);
        try {
            Dimension dimension = new Dimension((Dimension)FIELD_SIZE.get(tooltip));
            dimension.height += 4;
            dimension.width += 2;
            return dimension;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return new Dimension();
        }
    }

    @Override
    public void draw(CompoundNBT nbt, ICommonAccessor accessor, int x, int y) {
        Tooltip tooltip = this.geTooltip(nbt);
        if (tooltip == null) {
            return;
        }
        Rectangle rect = tooltip.getPosition();
        RenderSystem.enableBlend();
        int color = Color.GRAY.getRGB();
        MatrixStack matrix = RenderContext.matrixStack;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)y, 0.0);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)1, (int)rect.height, (int)color);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)rect.width, (int)1, (int)color);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)rect.width, (int)0, (int)(rect.width + 1), (int)rect.height, (int)color);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)0, (int)rect.height, (int)(rect.width + 1), (int)(rect.height + 1), (int)color);
        matrix.func_227861_a_((double)(-rect.x), (double)(-rect.y), 0.0);
        tooltip.draw();
        matrix.func_227865_b_();
    }

    private Tooltip geTooltip(CompoundNBT nbt) {
        try {
            return (Tooltip)this.cachedTooltips.get((Object)nbt, () -> {
                ListNBT tags = nbt.func_150295_c("in", 8);
                List<ITextComponent> components = tags.stream().map(tag -> ((HackyTextComponentNBT)((Object)((Object)tag))).getTextComponent()).collect(Collectors.toList());
                return new Tooltip(components, false);
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return new Tooltip(Collections.EMPTY_LIST, false);
        }
    }

    static {
        try {
            FIELD_SIZE = Tooltip.class.getDeclaredField("totalSize");
            FIELD_SIZE.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

