/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.text2speech.Narrator;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.TaggableList;
import mcp.mobius.waila.api.impl.TaggedTextComponent;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.gui.GuiOptions;
import mcp.mobius.waila.network.MessageRequestEntity;
import mcp.mobius.waila.network.MessageRequestTile;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextProcessing;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
public class WailaTickHandler {
    public static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static Narrator narrator;
    private static String lastNarration;
    public Tooltip tooltip = null;
    public MetaDataProvider handler = new MetaDataProvider();

    public void tickClient() {
        WailaConfig.ConfigGeneral config = Waila.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.tooltip = null;
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        if (!(client.field_71462_r instanceof GuiOptions) && (client.func_147113_T() || client.field_71462_r != null || client.field_195559_v == null)) {
            return;
        }
        ClientWorld world = client.field_71441_e;
        ClientPlayerEntity player = client.field_71439_g;
        if (world == null || player == null) {
            this.tooltip = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        RayTraceResult target = RayTracing.INSTANCE.getTarget();
        TaggableList<ResourceLocation, ITextComponent> currentTip = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
        TaggableList<ResourceLocation, ITextComponent> currentTipHead = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
        TaggableList<ResourceLocation, ITextComponent> currentTipBody = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
        TaggableList<ResourceLocation, ITextComponent> currentTipTail = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
        if (target == null || target.func_216346_c() == RayTraceResult.Type.MISS) {
            this.tooltip = null;
            return;
        }
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            ItemStack targetStack;
            DataAccessor accessor = DataAccessor.INSTANCE;
            accessor.set((World)world, (PlayerEntity)player, target);
            if (accessor.serverConnected && accessor.getTileEntity() != null && config.shouldDisplayTooltip()) {
                if (accessor.isTimeElapsed(MetaDataProvider.rateLimiter)) {
                    accessor.resetTimer();
                    if (WailaRegistrar.INSTANCE.hasNBTProviders(accessor.getBlock()) || WailaRegistrar.INSTANCE.hasNBTProviders(accessor.getTileEntity())) {
                        Waila.NETWORK.sendToServer((Object)new MessageRequestTile(accessor.getTileEntity()));
                    }
                }
                if (DataAccessor.INSTANCE.serverData == null && (WailaRegistrar.INSTANCE.hasNBTProviders(accessor.getBlock()) || WailaRegistrar.INSTANCE.hasNBTProviders(accessor.getTileEntity()))) {
                    return;
                }
            }
            accessor.stack = targetStack = RayTracing.INSTANCE.getTargetStack();
            WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipHead, TooltipPosition.HEAD);
            WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipBody, TooltipPosition.BODY);
            WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipTail, TooltipPosition.TAIL);
            this.combinePositions((PlayerEntity)player, currentTip, currentTipHead, currentTipBody, currentTipTail);
            this.tooltip = new Tooltip(currentTip, !targetStack.func_190926_b());
        } else if (target.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity targetEnt;
            DataAccessor accessor = DataAccessor.INSTANCE;
            accessor.set((World)world, (PlayerEntity)player, target);
            if (accessor.serverConnected && accessor.getEntity() != null && config.shouldDisplayTooltip()) {
                if (accessor.isTimeElapsed(MetaDataProvider.rateLimiter)) {
                    accessor.resetTimer();
                    if (WailaRegistrar.INSTANCE.hasNBTEntityProviders(accessor.getEntity())) {
                        Waila.NETWORK.sendToServer((Object)new MessageRequestEntity(accessor.getEntity()));
                    }
                }
                if (DataAccessor.INSTANCE.serverData == null && WailaRegistrar.INSTANCE.hasNBTEntityProviders(accessor.getEntity())) {
                    return;
                }
            }
            if ((targetEnt = RayTracing.INSTANCE.getTargetEntity()) != null) {
                WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipHead, TooltipPosition.HEAD);
                WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipBody, TooltipPosition.BODY);
                WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipTail, TooltipPosition.TAIL);
                this.combinePositions((PlayerEntity)player, currentTip, currentTipHead, currentTipBody, currentTipTail);
                ItemStack displayItem = RayTracing.INSTANCE.getIdentifierStack();
                this.tooltip = new Tooltip(currentTip, !displayItem.func_190926_b());
            }
        }
    }

    private void combinePositions(PlayerEntity player, List<ITextComponent> currentTip, List<ITextComponent> currentTipHead, List<ITextComponent> currentTipBody, List<ITextComponent> currentTipTail) {
        if (Waila.CONFIG.get().getGeneral().shouldShiftForDetails() && !currentTipBody.isEmpty() && !player.func_226563_dT_()) {
            currentTipBody.clear();
            currentTipBody.add((ITextComponent)new TranslationTextComponent("tooltip.waila.sneak_for_details").func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true))));
        }
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipHead);
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipBody);
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipTail);
    }

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onTooltip(WailaTooltipEvent event) {
        String narrate;
        if (event.getCurrentTip().isEmpty()) {
            return;
        }
        if (!WailaTickHandler.getNarrator().active() || !Waila.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71474_y.field_74343_n != ChatVisibility.HIDDEN) {
            return;
        }
        if (event.getAccessor().getBlock() == Blocks.field_150350_a && event.getAccessor().getEntity() == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 5L > 0L) {
            return;
        }
        ITextComponent component = event.getCurrentTip().get(0);
        if (component instanceof TaggedTextComponent && event.getCurrentTip() instanceof ITaggableList) {
            component = (ITextComponent)((ITaggableList)event.getCurrentTip()).getTag(((TaggedTextComponent)component).getTag());
        }
        if (lastNarration.equalsIgnoreCase(narrate = TextProcessing.func_244782_a((ITextProperties)component))) {
            return;
        }
        WailaTickHandler.getNarrator().clear();
        WailaTickHandler.getNarrator().say(narrate, true);
        lastNarration = narrate;
    }

    static {
        lastNarration = "";
    }
}

