/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.inspirations;

import java.util.ArrayList;
import java.util.List;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.DisplayCauldronRecipe;
import net.mehvahdjukaar.supplementaries.items.FlagItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.IMultiRecipe;

public class CauldronFlagClearRecipe
implements ICauldronRecipe,
IMultiRecipe<DisplayCauldronRecipe> {
    private final ResourceLocation id;
    private List<DisplayCauldronRecipe> displayRecipes;

    public CauldronFlagClearRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        ItemStack stack = inv.getStack();
        return inv.getLevel() >= 4 && inv.getContents().contains(CauldronContentTypes.FLUID, (Object)Fluids.field_204546_a) && stack.func_77973_b() instanceof FlagItem && BannerTileEntity.func_175113_c((ItemStack)stack) > 0;
    }

    public List<DisplayCauldronRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            this.displayRecipes = new ArrayList<DisplayCauldronRecipe>();
            for (DyeColor color : DyeColor.values()) {
                ItemStack stack = new ItemStack((IItemProvider)ModRegistry.FLAGS.get(color).get());
                CompoundNBT com = stack.func_190925_c("BlockEntityTag");
                ListNBT list = new ListNBT();
                CompoundNBT compoundnbt1 = new CompoundNBT();
                compoundnbt1.func_74778_a("Pattern", ((BannerPatternItem)Items.field_222097_pD).func_219980_b().func_190993_b());
                compoundnbt1.func_74768_a("Color", color == DyeColor.WHITE ? DyeColor.BLACK.func_196059_a() : DyeColor.WHITE.func_196059_a());
                list.add((Object)compoundnbt1);
                com.func_218657_a("Patterns", (INBT)list);
                this.displayRecipes.add(DisplayCauldronRecipe.builder((int)4, (int)0).setItemInputs(stack).setContentInputs(CauldronContentTypes.FLUID.of((Object)Fluids.field_204546_a)).setItemOutput(new ItemStack((IItemProvider)ModRegistry.FLAGS.get(color).get())).build());
            }
        }
        return this.displayRecipes;
    }

    public void handleRecipe(IModifyableCauldronInventory inv) {
        ItemStack stack = inv.splitStack(1);
        BannerTileEntity.func_175117_e((ItemStack)stack);
        inv.setOrGiveStack(stack);
        inv.addLevel(-4);
        inv.playSound(SoundEvents.field_187547_bF);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_REMOVE_BANNER_PATTERN;
    }
}

