/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.block.util.IColored;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.inventories.PresentContainer;
import net.mehvahdjukaar.supplementaries.items.PresentItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PresentBlockTile
extends ItemDisplayTile
implements IColored {
    public static final String PUBLIC_KEY = "@e";
    private String recipient = "";
    private String sender = "";
    private String description = "";

    public PresentBlockTile() {
        super((TileEntityType)ModRegistry.PRESENT_TILE.get(), 1);
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return ((PresentBlock)this.func_195044_w().func_177230_c()).getColor();
    }

    public static boolean isPacked(ItemStack stack) {
        CompoundNBT com = stack.func_77978_p();
        if (com != null) {
            CompoundNBT nbt = com.func_74775_l("BlockEntityTag");
            return nbt.func_74767_n("Packed");
        }
        return false;
    }

    public boolean isPacked() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)PresentBlock.PACKED);
    }

    public String getSender() {
        return this.sender;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRecipient() {
        if (this.recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return "";
        }
        return this.recipient;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setPublic() {
        this.setRecipient(PUBLIC_KEY);
    }

    public void updateState(boolean shouldPack, String newRecipient, String sender, String description) {
        if (shouldPack) {
            if (newRecipient.isEmpty()) {
                newRecipient = PUBLIC_KEY;
            }
            this.recipient = newRecipient;
            this.sender = sender;
            this.description = description;
        } else {
            this.recipient = "";
            this.sender = "";
            this.description = "";
        }
        if (!this.field_145850_b.field_72995_K && this.isPacked() != shouldPack) {
            if (shouldPack) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187748_db, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 1.2f);
            } else {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 1.2f);
            }
        }
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(shouldPack)), 3);
    }

    public boolean func_213904_e(PlayerEntity player) {
        return this.recipient.isEmpty() || this.recipient.equalsIgnoreCase(PUBLIC_KEY) || this.recipient.equalsIgnoreCase(player.func_200200_C_().getString()) || this.sender.equalsIgnoreCase(player.func_200200_C_().getString());
    }

    public ActionResultType interact(ServerPlayerEntity player, BlockPos pos) {
        if (this.func_213904_e((PlayerEntity)player)) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)pos);
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.present.info", new Object[]{this.recipient}), true);
        }
        return ActionResultType.CONSUME;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("gui.supplementaries.present");
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.recipient = "";
        this.sender = "";
        this.description = "";
        if (tag.func_74764_b("Recipient")) {
            this.recipient = tag.func_74779_i("Recipient");
        }
        if (tag.func_74764_b("Sender")) {
            this.sender = tag.func_74779_i("Sender");
        }
        if (tag.func_74764_b("Description")) {
            this.description = tag.func_74779_i("Description");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.recipient.isEmpty()) {
            tag.func_74778_a("Recipient", this.recipient);
        }
        if (!this.sender.isEmpty()) {
            tag.func_74778_a("Sender", this.sender);
        }
        if (!this.description.isEmpty()) {
            tag.func_74778_a("Description", this.description);
        }
        return tag;
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new PresentContainer(id, player, (IInventory)this, this.field_174879_c);
    }

    public static boolean isAcceptableItem(ItemStack stack) {
        return CommonUtil.isAllowedInShulker(stack) && !(stack.func_77973_b() instanceof PresentItem);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return PresentBlockTile.isAcceptableItem(stack);
    }

    public boolean func_180462_a(int p_19235_, ItemStack p_19236_, @Nullable Direction p_19237_) {
        return false;
    }

    public boolean func_180461_b(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return false;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }

    public ItemStack getPresentItem(IItemProvider block2) {
        CompoundNBT compoundTag = new CompoundNBT();
        this.func_189515_b(compoundTag);
        ItemStack itemstack = new ItemStack(block2);
        if (!compoundTag.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundTag);
        }
        if (this.func_145818_k_()) {
            itemstack.func_200302_a(this.func_200201_e());
        }
        return itemstack;
    }

    @Nullable
    public ITextComponent getSenderMessage() {
        return PresentBlockTile.getSenderMessage(this.sender);
    }

    @Nullable
    public static ITextComponent getSenderMessage(String sender) {
        if (sender.isEmpty()) {
            return null;
        }
        return new TranslationTextComponent("message.supplementaries.present.from", new Object[]{sender});
    }

    @Nullable
    public ITextComponent getRecipientMessage() {
        return PresentBlockTile.getRecipientMessage(this.recipient);
    }

    @Nullable
    public static ITextComponent getRecipientMessage(String recipient) {
        if (recipient.isEmpty()) {
            return null;
        }
        if (recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return new TranslationTextComponent("message.supplementaries.present.public");
        }
        return new TranslationTextComponent("message.supplementaries.present.to", new Object[]{recipient});
    }
}

