/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.selene.fluids.ISoftFluidConsumer;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.LingeringPotionItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.common.util.Lazy;

public class BambooSpikesBlock
extends WaterBlock
implements ISoftFluidConsumer,
IForgeBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty TIPPED = BlockProperties.TIPPED;
    public Lazy<Boolean> tippedEnabled = Lazy.of(() -> (Boolean)RegistryConfigs.reg.TIPPED_SPIKES_ENABLED.get());

    public BambooSpikesBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Potion p;
        CompoundNBT com;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BambooSpikesBlockTile && (com = stack.func_77978_p()) != null && (p = PotionUtils.func_185191_c((ItemStack)stack)) != Potions.field_185229_a && com.func_74764_b("Damage")) {
            ((BambooSpikesBlockTile)te).potion = p;
            ((BambooSpikesBlockTile)te).setMissingCharges(com.func_74762_e("Damage"));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        CompoundNBT com = context.func_195996_i().func_77978_p();
        int charges = com != null ? context.func_195996_i().func_77958_k() - com.func_74762_e("Damage") : 0;
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)TIPPED, (Comparable)Boolean.valueOf(charges != 0 && PotionUtils.func_185187_c((CompoundNBT)com) != Potions.field_185229_a));
    }

    public ItemStack getSpikeItem(TileEntity te) {
        if (te instanceof BambooSpikesBlockTile) {
            return ((BambooSpikesBlockTile)te).getSpikeItem();
        }
        return new ItemStack((IItemProvider)ModRegistry.BAMBOO_SPIKES_ITEM.get());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.getSpikeItem((TileEntity)builder.func_216019_b(LootParameters.field_216288_h)));
        return list;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return SHAPE_DOWN;
            }
            case UP: {
                return SHAPE_UP;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: 
        }
        return SHAPE_SOUTH;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).func_184812_l_()) {
            return;
        }
        if (entityIn instanceof LivingEntity && entityIn.func_70089_S()) {
            boolean up = state.func_177229_b((Property)FACING) == Direction.UP;
            double vy = up ? 0.45 : 0.95;
            entityIn.func_213295_a(state, new Vector3d(0.95, vy, 0.95));
            if (!worldIn.field_72995_K) {
                TileEntity te;
                if (up && entityIn instanceof PlayerEntity && entityIn.func_225608_bj_()) {
                    return;
                }
                float damage = entityIn.func_226278_cu_() > (double)pos.func_177956_o() + 0.0625 ? 2.0f : 1.0f;
                entityIn.func_70097_a(CommonUtil.SPIKE_DAMAGE, damage);
                if (((Boolean)state.func_177229_b((Property)TIPPED)).booleanValue() && (te = worldIn.func_175625_s(pos)) instanceof BambooSpikesBlockTile && ((BambooSpikesBlockTile)te).interactWithEntity((LivingEntity)entityIn, worldIn)) {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TIPPED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        }
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity2) {
        return PathNodeType.DAMAGE_OTHER;
    }

    public static boolean tryAddingPotion(BlockState state, IWorld world, BlockPos pos, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BambooSpikesBlockTile && ((BambooSpikesBlockTile)te).tryApplyPotion(PotionUtils.func_185191_c((ItemStack)stack))) {
            world.func_184133_a(null, pos, SoundEvents.field_226136_eQ_, SoundCategory.BLOCKS, 0.5f, 1.5f);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TIPPED, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!((Boolean)this.tippedEnabled.get()).booleanValue()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_77973_b() instanceof LingeringPotionItem) {
            if (BambooSpikesBlock.tryAddingPotion(state, (IWorld)worldIn, pos, stack) && !player.func_184812_l_()) {
                player.func_184611_a(handIn, DrinkHelper.func_241445_a_((ItemStack)stack.func_77946_l(), (PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Items.field_151069_bo), (boolean)false));
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED, TIPPED});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getSpikeItem(world.func_175625_s(pos));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BambooSpikesBlockTile();
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        TileEntity te;
        if (0.01 > (double)random.nextFloat() && ((Boolean)state.func_177229_b((Property)TIPPED)).booleanValue() && (te = world.func_175625_s(pos)) instanceof BambooSpikesBlockTile) {
            ((BambooSpikesBlockTile)te).makeParticle();
        }
    }

    public boolean tryAcceptingFluid(World world, BlockState state, BlockPos pos, SoftFluid f, @Nullable CompoundNBT nbt, int amount) {
        TileEntity te;
        if (!((Boolean)this.tippedEnabled.get()).booleanValue()) {
            return false;
        }
        if (f == SoftFluidRegistry.POTION && nbt != null && !((Boolean)state.func_177229_b((Property)TIPPED)).booleanValue() && nbt.func_74779_i("PotionType").equals("Lingering") && (te = world.func_175625_s(pos)) instanceof BambooSpikesBlockTile && ((BambooSpikesBlockTile)te).tryApplyPotion(PotionUtils.func_185187_c((CompoundNBT)nbt))) {
            world.func_184133_a(null, pos, SoundEvents.field_226136_eQ_, SoundCategory.BLOCKS, 0.5f, 1.5f);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TIPPED, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }
}

