/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeapolitanConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> milkCauldron;
        public final ForgeConfigSpec.ConfigValue<Boolean> milkingWithGlassBottles;
        public final ForgeConfigSpec.ConfigValue<Integer> strawberryBushGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Integer> vanillaVineGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Integer> adzukiSproutsGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Integer> mintPondGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Boolean> bananaPlantBeachGeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> bananaPlantJungleGeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpiderSpawning;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpidersFromBundles;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpidersGiveSlipping;
        public final ForgeConfigSpec.ConfigValue<Boolean> chimpanzeeSpawning;
        public final ForgeConfigSpec.ConfigValue<Double> chimpanzeeGroupChance;
        public final ForgeConfigSpec.ConfigValue<Integer> chimpanzeeMaxGroupSize;
        public final ForgeConfigSpec.ConfigValue<Integer> chimpanzeeMinSpawnAttempts;
        public final ForgeConfigSpec.ConfigValue<Integer> chimpanzeeMaxSpawnAttempts;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("items");
            builder.push("milk_bottles");
            this.milkCauldron = builder.comment("If milk can be inserted into cauldrons").define("Milk Cauldron", true);
            this.milkingWithGlassBottles = builder.comment("If milkable mobs can be milked with empty glass bottles").define("Milking with Glass Bottles", false);
            builder.pop();
            builder.pop();
            builder.push("world");
            builder.push("generation");
            this.strawberryBushGenerationChance = builder.comment("The chance Strawberry Bushes have to generate in Plains biomes (larger = more common)").define("Strawberry Bush chance", (Object)12);
            this.vanillaVineGenerationChance = builder.comment("The chance Vanilla Vines have to generate in Savanna biomes (larger = more common)").define("Vanilla Vine chance", (Object)10);
            this.adzukiSproutsGenerationChance = builder.comment("The chance Adzuki Sprouts have to generate in Forest biomes (larger = more common)").define("Adzuki Sprouts chance", (Object)7);
            this.mintPondGenerationChance = builder.comment("The chance ponds with Mint have to generate in Mountain biomes (larger = more common)").define("Mint pond chance", (Object)6);
            this.bananaPlantBeachGeneration = builder.define("Banana Plants generate in Beach biomes", true);
            this.bananaPlantJungleGeneration = builder.define("Banana Plants generate in Jungle biomes", true);
            builder.pop();
            builder.pop();
            builder.push("mobs");
            builder.push("plantain_spider");
            this.plantainSpiderSpawning = builder.define("Plantain Spider spawn in Jungles", true);
            this.plantainSpidersFromBundles = builder.define("Plantain Spider spawn from Banana Bundles", true);
            this.plantainSpidersGiveSlipping = builder.define("Plantain Spiders give Slipping", true);
            builder.pop();
            builder.push("chimpanzee");
            this.chimpanzeeSpawning = builder.define("Chimpanzee spawn in Jungles", true);
            this.chimpanzeeGroupChance = builder.comment("The percentage chance for a Banana Plant to generate with a group of Chimpanzees").define("Chimpanzee group chance", (Object)0.25);
            this.chimpanzeeMaxGroupSize = builder.comment("The maximum amount of Chimpanzees that can spawn with a Banana Plant").define("Chimpanzee maximum group size", (Object)10);
            this.chimpanzeeMinSpawnAttempts = builder.comment("The minimum attempts for Chimpanzees to spawn with a Banana Plant").define("Chimpanzee minimum spawn attempts", (Object)12);
            this.chimpanzeeMaxSpawnAttempts = builder.comment("The maximum attempts for Chimpanzees to spawn with a Banana Plant").define("Chimpanzee maximum spawn attempts", (Object)24);
            builder.pop();
            builder.pop();
        }
    }
}

