/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.world.gen.feature;

import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.minecraftabnormals.neapolitan.common.block.BananaFrondBlock;
import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.minecraftabnormals.neapolitan.core.NeapolitanConfig;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEntities;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BananaPlantFeature
extends Feature<NoFeatureConfig> {
    public BananaPlantFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockPos blockPos = pos;
        ArrayList<BlockPos> stalks = new ArrayList<BlockPos>();
        int size = 3 + random.nextInt(4);
        HashMap<BlockPos, Direction> smallFronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> fronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> largeFronds = new HashMap<BlockPos, Direction>();
        for (int i = 0; i < size; ++i) {
            stalks.add(blockPos);
            blockPos = blockPos.func_177984_a();
        }
        BlockPos bundle = null;
        BlockPos upFrond = blockPos;
        int i = 0;
        if (!BananaPlantFeature.isValidGround((IWorldGenerationBaseReader)level, pos.func_177977_b())) {
            return false;
        }
        for (BlockPos stalk : stalks) {
            if (i >= size - 3) {
                for (Direction direction : Direction.values()) {
                    if (!direction.func_176740_k().func_176722_c()) continue;
                    if (i == size - 1) {
                        if (random.nextInt(4) != 0) {
                            largeFronds.put(stalk.func_177972_a(direction), direction);
                            continue;
                        }
                        fronds.put(stalk.func_177972_a(direction), direction);
                        continue;
                    }
                    if (i == size - 2) {
                        if (random.nextBoolean()) {
                            fronds.put(stalk.func_177972_a(direction), direction);
                            continue;
                        }
                        if (random.nextBoolean() && bundle == null) {
                            bundle = stalk.func_177972_a(direction);
                            continue;
                        }
                        smallFronds.put(stalk.func_177972_a(direction), direction);
                        continue;
                    }
                    if (i != size - 3 || random.nextInt(3) == 0) continue;
                    smallFronds.put(stalk.func_177972_a(direction), direction);
                }
            }
            ++i;
        }
        if (BananaPlantFeature.isAirAt((IWorldGenerationBaseReader)level, pos, size) && pos.func_177956_o() < level.func_217301_I() - size) {
            for (BlockPos blockPos2 : stalks) {
                TreeUtil.setForcedState((IWorldWriter)level, (BlockPos)blockPos2, (BlockState)((Block)NeapolitanBlocks.BANANA_STALK.get()).func_176223_P());
            }
            TreeUtil.setForcedState((IWorldWriter)level, (BlockPos)upFrond, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).func_176223_P());
            if (bundle != null) {
                TreeUtil.setForcedState((IWorldWriter)level, bundle, (BlockState)((Block)NeapolitanBlocks.BANANA_BUNDLE.get()).func_176223_P());
                if (((Boolean)NeapolitanConfig.COMMON.chimpanzeeSpawning.get()).booleanValue() && random.nextInt(4) == 0 && level.func_226691_t_(pos).func_201856_r().equals((Object)Biome.Category.JUNGLE)) {
                    BananaPlantFeature.spawnChimps(level, pos);
                }
            }
            for (BlockPos blockPos2 : smallFronds.keySet()) {
                TreeUtil.setForcedState((IWorldWriter)level, (BlockPos)blockPos2, (BlockState)((BlockState)((Block)NeapolitanBlocks.SMALL_BANANA_FROND.get()).func_176223_P().func_206870_a((Property)BananaFrondBlock.FACING, (Comparable)smallFronds.get(blockPos2))));
            }
            for (BlockPos blockPos2 : fronds.keySet()) {
                TreeUtil.setForcedState((IWorldWriter)level, (BlockPos)blockPos2, (BlockState)((BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).func_176223_P().func_206870_a((Property)BananaFrondBlock.FACING, (Comparable)fronds.get(blockPos2))));
            }
            for (BlockPos blockPos2 : largeFronds.keySet()) {
                TreeUtil.setForcedState((IWorldWriter)level, (BlockPos)blockPos2, (BlockState)((BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).func_176223_P().func_206870_a((Property)BananaFrondBlock.FACING, (Comparable)largeFronds.get(blockPos2))));
            }
            if (BananaPlantFeature.isGrass((IWorldGenerationBaseReader)level, pos.func_177977_b())) {
                TreeUtil.setForcedState((IWorldWriter)level, (BlockPos)pos.func_177977_b(), (BlockState)Blocks.field_150351_n.func_176223_P());
                for (BlockPos blockpos : BlockPos.func_191531_b((int)(pos.func_177958_n() - 3), (int)(pos.func_177956_o() - 2), (int)(pos.func_177952_p() - 3), (int)(pos.func_177958_n() + 3), (int)(pos.func_177956_o() + 2), (int)(pos.func_177952_p() + 3))) {
                    if (!BananaPlantFeature.isGrass((IWorldGenerationBaseReader)level, blockpos) || !(random.nextDouble() < (Double)NeapolitanConfig.COMMON.chimpanzeeGroupChance.get()) || !TreeUtil.isAir((IWorldGenerationBaseReader)level, (BlockPos)blockpos.func_177984_a())) continue;
                    TreeUtil.setForcedState((IWorldWriter)level, (BlockPos)blockpos, (BlockState)Blocks.field_150351_n.func_176223_P());
                }
            }
            return true;
        }
        return false;
    }

    private static void spawnChimps(ISeedReader level, BlockPos pos) {
        Random random = level.func_201674_k();
        int minSpawnAttempts = (Integer)NeapolitanConfig.COMMON.chimpanzeeMinSpawnAttempts.get();
        int maxSpawnAttempts = (Integer)NeapolitanConfig.COMMON.chimpanzeeMaxSpawnAttempts.get();
        if (maxSpawnAttempts < minSpawnAttempts) {
            return;
        }
        int spawnCount = minSpawnAttempts + random.nextInt(maxSpawnAttempts - minSpawnAttempts);
        int spawnedChimps = 0;
        for (int i = 0; i < spawnCount; ++i) {
            ChimpanzeeEntity chimp;
            int spawnRange = 4;
            double d0 = (double)pos.func_177958_n() + (random.nextDouble() - random.nextDouble()) * (double)spawnRange + 0.5;
            double d1 = pos.func_177956_o() + random.nextInt(3) - 1;
            double d2 = (double)pos.func_177952_p() + (random.nextDouble() - random.nextDouble()) * (double)spawnRange + 0.5;
            if (!level.func_226664_a_(((EntityType)NeapolitanEntities.CHIMPANZEE.get()).func_220328_a(d0, d1, d2)) || spawnedChimps >= (Integer)NeapolitanConfig.COMMON.chimpanzeeMaxGroupSize.get() || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)((EntityType)NeapolitanEntities.CHIMPANZEE.get()), (IServerWorld)level, (SpawnReason)SpawnReason.STRUCTURE, (BlockPos)new BlockPos(d0, d1, d2), (Random)level.func_201674_k()) || (chimp = (ChimpanzeeEntity)((EntityType)NeapolitanEntities.CHIMPANZEE.get()).func_200721_a((World)level.func_201672_e())) == null) continue;
            chimp.func_70012_b(d0, d1, d2, level.func_201674_k().nextFloat() * 360.0f, 0.0f);
            chimp.func_213386_a((IServerWorld)level, level.func_175649_E(chimp.func_233580_cy_()), SpawnReason.STRUCTURE, null, null);
            chimp.func_82227_f(random.nextInt(4) == 0);
            level.func_217376_c((Entity)chimp);
            chimp.func_70656_aK();
            ++spawnedChimps;
        }
    }

    private static boolean isAirAt(IWorldGenerationBaseReader world, BlockPos pos, int size) {
        BlockPos position = pos.func_177984_a();
        for (int i = 0; i < size + 1; ++i) {
            if (!TreeUtil.isAir((IWorldGenerationBaseReader)world, (BlockPos)position)) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                if (!direction.func_176740_k().func_176722_c() || TreeUtil.isAir((IWorldGenerationBaseReader)world, (BlockPos)position.func_177972_a(direction))) continue;
                return false;
            }
            position = position.func_177984_a();
        }
        return true;
    }

    public static boolean isValidGround(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150351_n) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196658_i));
    }

    public static boolean isGrass(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_196658_i));
    }
}

