/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.item;

import com.minecraftabnormals.neapolitan.common.block.BeanstalkThornsBlock;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class AdzukiBeansItem
extends Item {
    private final boolean magic;

    public AdzukiBeansItem(boolean magic, Item.Properties builder) {
        super(builder);
        this.magic = magic;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Direction face = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        Random random = world.func_201674_k();
        ArrayList<Direction> offsetDirections = new ArrayList<Direction>();
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == face.func_176740_k()) continue;
            for (Direction direction : Direction.values()) {
                if (direction.func_176740_k() != axis) continue;
                offsetDirections.add(direction);
            }
        }
        if (!this.magic) {
            if ((state.func_203425_a(Blocks.field_150346_d) || state.func_203425_a(Blocks.field_196658_i)) && world.func_180495_p(pos.func_177984_a()).func_196958_f() && face == Direction.UP) {
                if (!world.func_201670_d()) {
                    world.func_175656_a(pos, ((Block)NeapolitanBlocks.ADZUKI_SOIL.get()).func_176223_P());
                }
                world.func_184133_a(null, pos, SoundEvents.field_219626_bz, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (player != null && !player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }
        ArrayList<BlockPos> beanstalkPositions = new ArrayList<BlockPos>();
        BlockPos offsetPos = pos.func_177972_a(face);
        if (state.func_185904_a().func_76222_j()) {
            offsetPos = pos;
        }
        world.func_184133_a(null, pos, SoundEvents.field_219626_bz, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.func_201670_d() && pos.func_177956_o() >= 0) {
            for (Direction direction : offsetDirections) {
                beanstalkPositions.add(offsetPos.func_177972_a(direction));
                BlockPos cornerPos = offsetPos.func_177972_a(direction).func_177972_a(AdzukiBeansItem.rotate(face.func_176740_k(), direction));
                if (random.nextInt(3) != 0) continue;
                beanstalkPositions.add(cornerPos);
            }
            Direction startingDirection = (Direction)offsetDirections.get(random.nextInt(4));
            block3: for (int i = 0; i < 3 + random.nextInt(4); ++i) {
                for (int j = 0; j < 3 + random.nextInt(3); ++j) {
                    if (j != 0) {
                        offsetPos = offsetPos.func_177972_a(face);
                    }
                    if (!world.func_180495_p(offsetPos).func_185904_a().func_76222_j()) break block3;
                    beanstalkPositions.add(offsetPos);
                }
                startingDirection = AdzukiBeansItem.rotate(face.func_176740_k(), startingDirection);
                offsetPos = offsetPos.func_177972_a(startingDirection);
            }
            int placed = 0;
            for (BlockPos blockPos : beanstalkPositions) {
                if (!AdzukiBeansItem.attemptPlaceBeanstalk(world, blockPos, face)) continue;
                ++placed;
            }
            if (placed > 0 && player != null && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            for (BlockPos blockPos : beanstalkPositions) {
                for (Direction direction : Direction.values()) {
                    BlockPos thornPos = blockPos.func_177972_a(direction);
                    BlockState beanState = (BlockState)((BlockState)((Block)NeapolitanBlocks.BEANSTALK_THORNS.get()).func_176223_P().func_206870_a((Property)BeanstalkThornsBlock.FACING, (Comparable)direction)).func_206870_a((Property)BeanstalkThornsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(thornPos).func_206886_c() == Fluids.field_204546_a));
                    if (!world.func_180495_p(blockPos).func_203425_a((Block)NeapolitanBlocks.BEANSTALK.get()) || !world.func_180495_p(thornPos).func_185904_a().func_76222_j() || random.nextInt(4) != 0 || !beanState.func_196955_c((IWorldReader)world, thornPos)) continue;
                    world.func_175656_a(thornPos, beanState);
                }
            }
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    private static boolean attemptPlaceBeanstalk(World world, BlockPos pos, Direction direction) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            return world.func_175656_a(pos, (BlockState)((Block)NeapolitanBlocks.BEANSTALK.get()).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()));
        }
        return false;
    }

    private static Direction rotate(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            switch (face) {
                case NORTH: {
                    return Direction.EAST;
                }
                case SOUTH: {
                    return Direction.WEST;
                }
                case WEST: {
                    return Direction.NORTH;
                }
                case EAST: {
                    return Direction.SOUTH;
                }
            }
            throw new IllegalStateException("Unable to get rotated facing of " + face);
        }
        if (axis == Direction.Axis.Z) {
            switch (face) {
                case UP: {
                    return Direction.EAST;
                }
                case DOWN: {
                    return Direction.WEST;
                }
                case WEST: {
                    return Direction.UP;
                }
                case EAST: {
                    return Direction.DOWN;
                }
            }
            throw new IllegalStateException("Unable to get rotated facing of " + face);
        }
        if (axis == Direction.Axis.X) {
            switch (face) {
                case UP: {
                    return Direction.NORTH;
                }
                case DOWN: {
                    return Direction.SOUTH;
                }
                case SOUTH: {
                    return Direction.UP;
                }
                case NORTH: {
                    return Direction.DOWN;
                }
            }
            throw new IllegalStateException("Unable to get rotated facing of " + face);
        }
        return face;
    }
}

