/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stal111.valhelsia_structures.init.ModRecipes;
import com.stal111.valhelsia_structures.utils.ModTags;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AxeCraftingRecipe
extends SpecialRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final int count;

    public AxeCraftingRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output) {
        super(recipeId);
        this.input = input;
        this.output = output;
        this.count = output.func_190916_E();
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int axeSlot = -1;
        ItemStack stack = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            Item item = inv.func_70301_a(slot).func_77973_b();
            if (!(item instanceof AxeItem) || ModTags.Items.AXE_CRAFTING_BLACKLISTED.func_230235_a_((Object)item)) continue;
            axeSlot = slot;
            break;
        }
        if (axeSlot == -1) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack1 = inv.func_70301_a(i);
            if (i == axeSlot || stack1.func_190926_b()) continue;
            if (this.input.test(stack1) && (stack == null || stack.func_77969_a(stack1))) {
                stack = stack1;
                continue;
            }
            return false;
        }
        return stack != null;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        int logCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!this.input.test(stack)) continue;
            ++logCount;
        }
        return new ItemStack((IItemProvider)this.output.func_77973_b(), logCount * this.count);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        int i;
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int logCount = 0;
        for (i = 0; i < nonnulllist.size(); ++i) {
            if (!this.input.test(inv.func_70301_a(i))) continue;
            ++logCount;
        }
        for (i = 0; i < nonnulllist.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof AxeItem)) continue;
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_196085_b(stack1.func_77952_i() + logCount);
            if (stack1.func_77952_i() >= stack1.func_77958_k()) continue;
            nonnulllist.set(i, (Object)stack1);
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.AXE_CRAFTING_SERIALIZER.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AxeCraftingRecipe> {
        public AxeCraftingRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            return new AxeCraftingRecipe(recipeId, input, output);
        }

        public AxeCraftingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            return new AxeCraftingRecipe(recipeId, input, output);
        }

        public void write(PacketBuffer buffer, AxeCraftingRecipe recipe) {
            recipe.input.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
        }
    }
}

