/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.event;

import com.stal111.valhelsia_structures.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.init.ModStructures;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.world.IValhelsiaStructure;

@Mod.EventBusSubscriber
public class BiomeLoadingListener {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        Biome.Category category = event.getCategory();
        if (name != null) {
            for (String biome : (List)StructureGenConfig.BLACKLISTED_BIOMES.get()) {
                if (!biome.equals(name.toString()) && !BiomeLoadingListener.checkWildcard(biome, name.toString())) continue;
                return;
            }
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
                StructureConfigEntry configEntry = structure.getStructureConfigEntry();
                if (!((Boolean)configEntry.generate.get()).booleanValue() || !BiomeLoadingListener.checkBiome((List)configEntry.configuredBiomeCategories.get(), (List)configEntry.configuredBlacklistedBiomes.get(), name, category)) continue;
                event.getGeneration().func_242516_a(structure.getStructureFeature());
            }
        }
    }

    private static boolean checkWildcard(String blacklistedBiome, String biome) {
        if (blacklistedBiome.startsWith("*") && blacklistedBiome.endsWith("*")) {
            return biome.contains(blacklistedBiome.substring(1, blacklistedBiome.length() - 1));
        }
        if (blacklistedBiome.startsWith("*")) {
            return biome.endsWith(blacklistedBiome.substring(1));
        }
        if (blacklistedBiome.endsWith("*")) {
            return biome.startsWith(blacklistedBiome.substring(0, blacklistedBiome.length() - 1));
        }
        return false;
    }

    private static boolean checkBiome(List<? extends String> allowedBiomeCategories, List<? extends String> blacklistedBiomes, ResourceLocation name, Biome.Category category) {
        boolean flag = allowedBiomeCategories.contains(category.func_222352_a());
        if (!blacklistedBiomes.isEmpty() && flag) {
            boolean bl = flag = !blacklistedBiomes.contains(name.toString());
            if (flag) {
                for (String string : blacklistedBiomes) {
                    if (!BiomeLoadingListener.checkWildcard(string, name.toString())) continue;
                    flag = false;
                    break;
                }
            }
        }
        return flag;
    }
}

