/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import java.util.Random;
import mod.beethoven92.betterendforge.BetterEnd;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.StructureHelper;
import mod.beethoven92.betterendforge.common.util.WorldDataAPI;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndSpikeFeature;
import net.minecraft.world.gen.feature.EndSpikeFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndSpikeFeature.class})
public abstract class EndSpikeFeatureMixin {
    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true)
    private void beGenerateSpike(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, EndSpikeFeatureConfig endSpikeFeatureConfig, CallbackInfoReturnable<Boolean> info) {
        if (!GeneratorOptions.hasPillars()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"placeSpike"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_placeSpike(IServerWorld world, Random random, EndSpikeFeatureConfig config, EndSpikeFeature.EndSpike spike, CallbackInfo info) {
        int x = spike.func_186151_a();
        int z = spike.func_186152_b();
        int radius = spike.func_186148_c();
        int minY = 0;
        long lx = x;
        long lz = z;
        if (lx * lx + lz * lz < 10000L) {
            String pillarID = String.format("%d_%d", x, z);
            CompoundNBT pillar = WorldDataAPI.getCompoundTag("betterendforge", "pillars");
            boolean haveValue = pillar.func_74764_b(pillarID);
            int n = minY = haveValue ? pillar.func_74762_e(pillarID) : world.func_212866_a_(x >> 4, z >> 4).func_201576_a(Heightmap.Type.WORLD_SURFACE, x & 0xF, z);
            if (!haveValue) {
                pillar.func_74768_a(pillarID, minY);
            }
        } else {
            minY = world.func_212866_a_(x >> 4, z >> 4).func_201576_a(Heightmap.Type.WORLD_SURFACE, x & 0xF, z);
        }
        GeneratorOptions.setDirectSpikeHeight();
        int maxY = minY + spike.func_186149_d() - 64;
        if (GeneratorOptions.replacePillars() && this.be_radiusInRange(radius)) {
            Template base = StructureHelper.readStructure(BetterEnd.makeID("pillars/pillar_base_" + --radius));
            Template top = StructureHelper.readStructure(BetterEnd.makeID("pillars/pillar_top_" + radius + (spike.func_186150_e() ? "_cage" : "")));
            BlockPos side = base.func_186259_a();
            BlockPos pos1 = new BlockPos(x - (side.func_177958_n() >> 1), minY - 3, z - (side.func_177952_p() >> 1));
            minY = pos1.func_177956_o() + side.func_177956_o();
            side = top.func_186259_a();
            BlockPos pos2 = new BlockPos(x - (side.func_177958_n() >> 1), maxY, z - (side.func_177952_p() >> 1));
            maxY = pos2.func_177956_o();
            PlacementSettings data = new PlacementSettings();
            base.func_237146_a_(world, pos1, pos1, data, random, 2);
            top.func_237146_a_(world, pos2, pos2, data, random, 2);
            int r2 = radius * radius + 1;
            BlockPos.Mutable mut = new BlockPos.Mutable();
            for (int px = -radius; px <= radius; ++px) {
                mut.func_223471_o(x + px);
                int x2 = px * px;
                for (int pz = -radius; pz <= radius; ++pz) {
                    mut.func_223472_q(z + pz);
                    int z2 = pz * pz;
                    if (x2 + z2 > r2) continue;
                    for (int py = minY; py < maxY; ++py) {
                        mut.func_185336_p(py);
                        if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                        if ((px == radius || px == -radius || pz == radius || pz == -radius) && random.nextInt(24) == 0) {
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_235399_ni_);
                            continue;
                        }
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150343_Z);
                    }
                }
            }
        } else {
            minY -= 15;
            int r2 = radius * radius + 1;
            BlockPos.Mutable mut = new BlockPos.Mutable();
            for (int px = -radius; px <= radius; ++px) {
                mut.func_223471_o(x + px);
                int x2 = px * px;
                for (int pz = -radius; pz <= radius; ++pz) {
                    mut.func_223472_q(z + pz);
                    int z2 = pz * pz;
                    if (x2 + z2 > r2) continue;
                    for (int py = minY; py < maxY; ++py) {
                        mut.func_185336_p(py);
                        if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150343_Z);
                    }
                }
            }
            mut.func_223471_o(x);
            mut.func_223472_q(z);
            mut.func_185336_p(maxY);
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150357_h);
            EnderCrystalEntity crystal = (EnderCrystalEntity)EntityType.field_200801_o.func_200721_a((World)world.func_201672_e());
            crystal.func_184516_a(config.func_214668_c());
            crystal.func_184224_h(config.func_214669_a());
            crystal.func_70012_b((double)x + 0.5, (double)(maxY + 1), (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
            world.func_217376_c((Entity)crystal);
            if (spike.func_186150_e()) {
                for (int px = -2; px <= 2; ++px) {
                    boolean bl = MathHelper.func_76130_a((int)px) == 2;
                    for (int pz = -2; pz <= 2; ++pz) {
                        boolean bl2 = MathHelper.func_76130_a((int)pz) == 2;
                        for (int py = 0; py <= 3; ++py) {
                            boolean bl3;
                            boolean bl4 = bl3 = py == 3;
                            if (!bl && !bl2 && !bl3) continue;
                            boolean bl42 = px == -2 || px == 2 || bl3;
                            boolean bl5 = pz == -2 || pz == 2 || bl3;
                            BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(bl42 && pz != -2))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(bl42 && pz != 2))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(bl5 && px != -2))).func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(bl5 && px != 2));
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut.func_181079_c(spike.func_186151_a() + px, maxY + py, spike.func_186152_b() + pz), blockState);
                        }
                    }
                }
            }
        }
        info.cancel();
    }

    private boolean be_radiusInRange(int radius) {
        return radius > 1 && radius < 6;
    }
}

