/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import java.awt.Point;
import java.util.Arrays;
import java.util.Comparator;
import mod.beethoven92.betterendforge.client.ClientOptions;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeColors.class})
public class BiomeColorsMixin {
    private static final int POISON_COLOR = ModMathHelper.color(92, 160, 78);
    private static final int STREAM_COLOR = ModMathHelper.color(105, 213, 244);
    private static final Point[] OFFSETS;
    private static final boolean HAS_MAGNESIUM;

    @Inject(method={"getWaterColor"}, at={@At(value="RETURN")}, cancellable=true)
    private static void be_getWaterColor(IBlockDisplayReader world, BlockPos blockPos, CallbackInfoReturnable<Integer> info) {
        if (ClientOptions.useSulfurWaterColor()) {
            IBlockDisplayReader view = HAS_MAGNESIUM ? Minecraft.func_71410_x().field_71441_e : world;
            BlockPos.Mutable mut = new BlockPos.Mutable();
            mut.func_185336_p(blockPos.func_177956_o());
            for (int i = 0; i < OFFSETS.length; ++i) {
                mut.func_223471_o(blockPos.func_177958_n() + BiomeColorsMixin.OFFSETS[i].x);
                mut.func_223472_q(blockPos.func_177952_p() + BiomeColorsMixin.OFFSETS[i].y);
                if (!view.func_180495_p((BlockPos)mut).func_203425_a((Block)ModBlocks.BRIMSTONE.get())) continue;
                info.setReturnValue((Object)(i < 4 ? POISON_COLOR : STREAM_COLOR));
                return;
            }
        }
    }

    static {
        HAS_MAGNESIUM = ModList.get().isLoaded("magnesium");
        int index = 0;
        OFFSETS = new Point[20];
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (x == 0 && z == 0 || Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                BiomeColorsMixin.OFFSETS[index++] = new Point(x, z);
            }
        }
        Arrays.sort(OFFSETS, Comparator.comparingInt(pos -> ModMathHelper.sqr(pos.x) + ModMathHelper.sqr(pos.y)));
    }
}

