/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.structure.piece;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModStructurePieces;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import mod.beethoven92.betterendforge.common.world.structure.piece.BasePiece;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CavePiece
extends BasePiece {
    private OpenSimplexNoise noise;
    private BlockPos center;
    private float radius;

    public CavePiece(BlockPos center, float radius, Random random) {
        super(ModStructurePieces.CAVE_PIECE, random.nextInt());
        this.center = center;
        this.radius = radius;
        this.noise = new OpenSimplexNoise(ModMathHelper.getSeed(534, center.func_177958_n(), center.func_177952_p()));
        this.makeBoundingBox();
    }

    public CavePiece(TemplateManager templateManager, CompoundNBT tag) {
        super(ModStructurePieces.CAVE_PIECE, tag);
        this.makeBoundingBox();
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager arg, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int x1 = ModMathHelper.max(this.func_74874_b().field_78897_a, blockBox.field_78897_a);
        int z1 = ModMathHelper.max(this.func_74874_b().field_78896_c, blockBox.field_78896_c);
        int x2 = ModMathHelper.min(this.func_74874_b().field_78893_d, blockBox.field_78893_d);
        int z2 = ModMathHelper.min(this.func_74874_b().field_78892_f, blockBox.field_78892_f);
        int y1 = this.func_74874_b().field_78895_b;
        int y2 = this.func_74874_b().field_78894_e;
        double hr = (double)this.radius * 0.75;
        double nr = (double)this.radius * 0.25;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - this.center.func_177958_n();
            xsq *= xsq;
            pos.func_223471_o(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - this.center.func_177952_p();
                zsq *= zsq;
                pos.func_223472_q(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - this.center.func_177956_o();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    pos.func_185336_p(y);
                    double r = this.noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r - 4.5;
                    double dist = xsq + ysq + zsq;
                    if (dist < r2 * r2) {
                        if (!world.func_180495_p((BlockPos)pos).func_235714_a_(ModTags.END_GROUND)) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)pos, field_202556_l);
                        continue;
                    }
                    if (!(dist < r * r) || !world.func_180495_p((BlockPos)pos).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)pos, Blocks.field_150377_bs);
                }
            }
        }
        return true;
    }

    protected void func_143011_b(CompoundNBT tag) {
        this.center = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("center"));
        this.radius = tag.func_74760_g("radius");
    }

    private void makeBoundingBox() {
        int minX = ModMathHelper.floor((float)this.center.func_177958_n() - this.radius);
        int minY = ModMathHelper.floor((float)this.center.func_177956_o() - this.radius);
        int minZ = ModMathHelper.floor((float)this.center.func_177952_p() - this.radius);
        int maxX = ModMathHelper.floor((float)this.center.func_177958_n() + this.radius + 1.0f);
        int maxY = ModMathHelper.floor((float)this.center.func_177956_o() + this.radius + 1.0f);
        int maxZ = ModMathHelper.floor((float)this.center.func_177952_p() + this.radius + 1.0f);
        this.field_74887_e = new MutableBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    protected void fromNbt(CompoundNBT tag) {
        tag.func_218657_a("center", (INBT)NBTUtil.func_186859_a((BlockPos)this.center));
        tag.func_74776_a("radius", this.radius);
        this.noise = new OpenSimplexNoise(ModMathHelper.getSeed(534, this.center.func_177958_n(), this.center.func_177952_p()));
    }
}

