/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import java.util.List;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;

public class WeighTree {
    private final Node root;

    public WeighTree(List<BetterEndBiome> biomes) {
        this.root = this.getNode(biomes);
    }

    public BetterEndBiome getBiome(float value) {
        return this.root.getBiome(value);
    }

    private Node getNode(List<BetterEndBiome> biomes) {
        int size = biomes.size();
        if (size == 1) {
            return new Leaf(biomes.get(0));
        }
        if (size == 2) {
            BetterEndBiome first = biomes.get(0);
            return new Branch(first.getGenChance(), new Leaf(first), new Leaf(biomes.get(1)));
        }
        int index = size >> 1;
        float separator = biomes.get(index).getGenChance();
        Node a = this.getNode(biomes.subList(0, index + 1));
        Node b = this.getNode(biomes.subList(index, size));
        return new Branch(separator, a, b);
    }

    private class Leaf
    extends Node {
        final BetterEndBiome biome;

        Leaf(BetterEndBiome biome) {
            this.biome = biome;
        }

        @Override
        BetterEndBiome getBiome(float value) {
            return this.biome;
        }
    }

    private class Branch
    extends Node {
        final float separator;
        final Node min;
        final Node max;

        public Branch(float separator, Node min, Node max) {
            this.separator = separator;
            this.min = min;
            this.max = max;
        }

        @Override
        BetterEndBiome getBiome(float value) {
            return value < this.separator ? this.min.getBiome(value) : this.max.getBiome(value);
        }
    }

    private abstract class Node {
        private Node() {
        }

        abstract BetterEndBiome getBiome(float var1);
    }
}

