/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.generator.BiomeMap;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import mod.beethoven92.betterendforge.common.world.generator.TerrainGenerator;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class BetterEndBiomeProvider
extends BiomeProvider {
    public static final Codec<BetterEndBiomeProvider> BETTER_END_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(provider -> provider.lookupRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(provider -> provider.seed)).apply((Applicative)builder, builder.stable(BetterEndBiomeProvider::new)));
    private static final OpenSimplexNoise SMALL_NOISE = new OpenSimplexNoise(8324L);
    private final SimplexNoiseGenerator generator;
    private final Registry<Biome> lookupRegistry;
    private final Biome centerBiome;
    private final Biome barrens;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private final long seed;

    public BetterEndBiomeProvider(Registry<Biome> lookupRegistry, long seed) {
        super(BetterEndBiomeProvider.getBiomes(lookupRegistry));
        this.mapLand = new BiomeMap(seed, GeneratorOptions.getBiomeSizeLand(), ModBiomes.LAND_BIOMES);
        this.mapVoid = new BiomeMap(seed, GeneratorOptions.getBiomeSizeVoid(), ModBiomes.VOID_BIOMES);
        this.centerBiome = (Biome)lookupRegistry.func_243576_d(Biomes.field_76779_k);
        this.barrens = (Biome)lookupRegistry.func_243576_d(Biomes.field_201939_S);
        this.lookupRegistry = lookupRegistry;
        this.seed = seed;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        sharedseedrandom.func_202423_a(17292);
        this.generator = new SimplexNoiseGenerator((Random)sharedseedrandom);
        ModBiomes.mutateRegistry(lookupRegistry);
    }

    private static List<Biome> getBiomes(Registry<Biome> biomeRegistry) {
        ArrayList list = Lists.newArrayList();
        biomeRegistry.forEach(biome -> {
            if (ModBiomes.hasBiome(biomeRegistry.func_177774_c(biome))) {
                list.add(biome);
            }
        });
        return list;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        boolean hasVoid = !GeneratorOptions.useNewGenerator() || !GeneratorOptions.noRingVoid();
        long i = (long)x * (long)x;
        long j = (long)z * (long)z;
        if (hasVoid && i + j <= 65536L) {
            return this.centerBiome;
        }
        if (x == 0 && z == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
        }
        if (GeneratorOptions.useNewGenerator()) {
            if (TerrainGenerator.isLand(x, z)) {
                return this.mapLand.getBiome(x << 2, z << 2).getActualBiome();
            }
            return this.mapVoid.getBiome(x << 2, z << 2).getActualBiome();
        }
        float height = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.generator, (int)((x >> 1) + 1), (int)((z >> 1) + 1)) + (float)SMALL_NOISE.eval(x, z) * 5.0f;
        if (height > -20.0f && height < -5.0f) {
            return this.barrens;
        }
        BetterEndBiome endBiome = height < -10.0f ? this.mapVoid.getBiome(x << 2, z << 2) : this.mapLand.getBiome(x << 2, z << 2);
        return endBiome.getActualBiome();
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return BETTER_END_CODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BetterEndBiomeProvider(this.lookupRegistry, seed);
    }

    public static void register() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("betterendforge", "betterend_biome_provider"), BETTER_END_CODEC);
    }
}

