/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature.caves;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndCaveBiome;
import mod.beethoven92.betterendforge.common.world.feature.caves.EndCaveFeature;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class TunelCaveFeature
extends EndCaveFeature {
    private Set<BlockPos> generate(ISeedReader world, BlockPos center, Random random) {
        int cz;
        int cx = center.func_177958_n() >> 4;
        if ((long)cx * (long)cx + (long)(cz = center.func_177952_p() >> 4) + (long)cz < 256L) {
            return Sets.newHashSet();
        }
        int x1 = cx << 4;
        int z1 = cz << 4;
        int x2 = x1 + 16;
        int z2 = z1 + 16;
        Random rand = new Random(world.func_72905_C());
        OpenSimplexNoise noiseH = new OpenSimplexNoise(rand.nextInt());
        OpenSimplexNoise noiseV = new OpenSimplexNoise(rand.nextInt());
        OpenSimplexNoise noiseD = new OpenSimplexNoise(rand.nextInt());
        Set positions = Sets.newConcurrentHashSet();
        float a = this.hasCaves(world, new BlockPos(x1, 0, z1)) ? 1.0f : 0.0f;
        float b = this.hasCaves(world, new BlockPos(x2, 0, z1)) ? 1.0f : 0.0f;
        float c = this.hasCaves(world, new BlockPos(x1, 0, z2)) ? 1.0f : 0.0f;
        float d = this.hasCaves(world, new BlockPos(x2, 0, z2)) ? 1.0f : 0.0f;
        IChunk chunk = world.func_212866_a_(cx, cz);
        IntStream.range(0, 256).parallel().forEach(index -> {
            BlockPos.Mutable pos = new BlockPos.Mutable();
            int x = index & 0xF;
            int z = index >> 4;
            int wheight = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
            float dx = (float)x / 16.0f;
            float dz = (float)z / 16.0f;
            pos.func_223471_o(x + x1);
            pos.func_223472_q(z + z1);
            float da = MathHelper.func_219799_g((float)dx, (float)a, (float)b);
            float db = MathHelper.func_219799_g((float)dx, (float)c, (float)d);
            float density = 1.0f - MathHelper.func_219799_g((float)dz, (float)da, (float)db);
            if ((double)density < 0.5) {
                for (int y = 0; y < wheight; ++y) {
                    float dist;
                    pos.func_185336_p(y);
                    float gradient = 1.0f - MathHelper.func_76131_a((float)((float)(wheight - y) * 0.1f), (float)0.0f, (float)1.0f);
                    if ((double)gradient > 0.5) break;
                    float val = MathHelper.func_76135_e((float)((float)noiseH.eval((double)pos.func_177958_n() * 0.02, (double)y * 0.01, (double)pos.func_177952_p() * 0.02)));
                    float vert = MathHelper.func_76126_a((float)(((float)y + (float)noiseV.eval((double)pos.func_177958_n() * 0.01, (double)pos.func_177952_p() * 0.01) * 20.0f) * 0.1f)) * 0.9f;
                    if (!((double)(val = val + vert * vert + (dist = (float)noiseD.eval((double)pos.func_177958_n() * 0.1, (double)y * 0.1, (double)pos.func_177952_p() * 0.1) * 0.12f) + density + gradient) < 0.15) || !world.func_180495_p((BlockPos)pos).func_235714_a_(ModTags.GEN_TERRAIN) || !this.noWaterNear(world, (BlockPos)pos)) continue;
                    positions.add(pos.func_185334_h());
                }
            }
        });
        positions.forEach(bpos -> BlockHelper.setWithoutUpdate((IWorldWriter)world, bpos, CAVE_AIR));
        return positions;
    }

    private boolean noWaterNear(ISeedReader world, BlockPos pos) {
        BlockPos above1 = pos.func_177984_a();
        BlockPos above2 = pos.func_177981_b(2);
        if (!world.func_204610_c(above1).func_206888_e() || !world.func_204610_c(above2).func_206888_e()) {
            return false;
        }
        for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
            if (!world.func_204610_c(above1.func_177972_a(dir)).func_206888_e()) {
                return false;
            }
            if (world.func_204610_c(above2.func_177972_a(dir)).func_206888_e()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (pos.func_177958_n() * pos.func_177958_n() + pos.func_177952_p() * pos.func_177952_p() <= 2500) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        Set<BlockPos> caveBlocks = this.generate(world, pos, random);
        if (caveBlocks.isEmpty()) {
            return false;
        }
        HashMap floorSets = Maps.newHashMap();
        HashMap ceilSets = Maps.newHashMap();
        BlockPos.Mutable mut = new BlockPos.Mutable();
        HashSet remove = Sets.newHashSet();
        caveBlocks.forEach(bpos -> {
            mut.func_189533_g((Vector3i)bpos);
            BetterEndCaveBiome bio = ModBiomes.getCaveBiome(random);
            int height = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, bpos.func_177958_n(), bpos.func_177952_p());
            if (mut.func_177956_o() >= height) {
                remove.add(bpos);
            } else if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                mut.func_185336_p(bpos.func_177956_o() - 1);
                if (world.func_180495_p((BlockPos)mut).func_235714_a_(ModTags.GEN_TERRAIN)) {
                    Set floorPositions = (Set)floorSets.get(bio);
                    if (floorPositions == null) {
                        floorPositions = Sets.newHashSet();
                        floorSets.put(bio, floorPositions);
                    }
                    floorPositions.add(mut.func_185334_h());
                }
                mut.func_185336_p(bpos.func_177956_o() + 1);
                if (world.func_180495_p((BlockPos)mut).func_235714_a_(ModTags.GEN_TERRAIN)) {
                    Set ceilPositions = (Set)ceilSets.get(bio);
                    if (ceilPositions == null) {
                        ceilPositions = Sets.newHashSet();
                        ceilSets.put(bio, ceilPositions);
                    }
                    ceilPositions.add(mut.func_185334_h());
                }
                this.setBiome(world, (BlockPos)bpos, bio);
            }
        });
        caveBlocks.removeAll(remove);
        if (caveBlocks.isEmpty()) {
            return true;
        }
        floorSets.forEach((biome, floorPositions) -> {
            BlockState surfaceBlock = biome.getBiome().func_242440_e().func_242502_e().func_204108_a();
            this.placeFloor(world, (BetterEndCaveBiome)biome, (Set<BlockPos>)floorPositions, random, surfaceBlock);
        });
        ceilSets.forEach((biome, ceilPositions) -> this.placeCeil(world, (BetterEndCaveBiome)biome, (Set<BlockPos>)ceilPositions, random));
        BetterEndCaveBiome biome2 = ModBiomes.getCaveBiome(random);
        this.placeWalls(world, biome2, caveBlocks, random);
        this.fixBlocks(world, caveBlocks);
        return true;
    }

    @Override
    protected Set<BlockPos> generateCaveBlocks(ISeedReader world, BlockPos center, int radius, Random random) {
        return null;
    }

    @Override
    protected void placeFloor(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> floorPositions, Random random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity() * 0.2f;
        floorPositions.forEach(pos -> {
            Feature<?> feature;
            if (!surfaceBlock.func_203425_a(Blocks.field_150377_bs)) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, surfaceBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getFloorFeature(random)) != null) {
                feature.func_241855_a(world, null, random, pos.func_177984_a(), null);
            }
        });
    }

    @Override
    protected void placeCeil(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> ceilPositions, Random random) {
        float density = biome.getCeilDensity() * 0.2f;
        ceilPositions.forEach(pos -> {
            Feature<?> feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, ceilBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getCeilFeature(random)) != null) {
                feature.func_241855_a(world, null, random, pos.func_177977_b(), null);
            }
        });
    }

    protected boolean hasCaves(ISeedReader world, BlockPos pos) {
        return this.hasCavesInBiome(world, pos.func_177982_a(-8, 0, -8)) && this.hasCavesInBiome(world, pos.func_177982_a(8, 0, -8)) && this.hasCavesInBiome(world, pos.func_177982_a(-8, 0, 8)) && this.hasCavesInBiome(world, pos.func_177982_a(8, 0, 8));
    }

    protected boolean hasCavesInBiome(ISeedReader world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        BetterEndBiome endBiome = ModBiomes.getFromBiome(biome);
        return endBiome.hasCaves();
    }
}

