/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.template.DoublePlantBlock;
import mod.beethoven92.betterendforge.common.block.template.EndCropBlock;
import mod.beethoven92.betterendforge.common.block.template.PlantBlockWithAge;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.world.feature.ScatterFeature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;

public class SinglePlantFeature
extends ScatterFeature {
    private final Block plant;
    private final boolean rawHeightmap;
    private final int chance;

    public SinglePlantFeature(Block plant, int radius) {
        this(plant, radius, true, 1);
    }

    public SinglePlantFeature(Block plant, int radius, int chance) {
        this(plant, radius, true, chance);
    }

    public SinglePlantFeature(Block plant, int radius, boolean rawHeightmap) {
        this(plant, radius, rawHeightmap, 1);
    }

    public SinglePlantFeature(Block plant, int radius, boolean rawHeightmap, int chance) {
        super(radius);
        this.plant = plant;
        this.rawHeightmap = rawHeightmap;
        this.chance = chance;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    protected BlockPos getCenterGround(ISeedReader world, BlockPos pos) {
        return this.rawHeightmap ? FeatureHelper.getPosOnSurfaceWG(world, pos) : FeatureHelper.getPosOnSurface(world, pos);
    }

    @Override
    public boolean canGenerate(ISeedReader world, Random random, BlockPos center, BlockPos blockPos, float radius) {
        return this.plant.func_196260_a(this.plant.func_176223_P(), (IWorldReader)world, blockPos);
    }

    @Override
    public void generate(ISeedReader world, Random random, BlockPos blockPos) {
        if (this.plant instanceof DoublePlantBlock) {
            int rot = random.nextInt(4);
            BlockState state = (BlockState)this.plant.func_176223_P().func_206870_a((Property)DoublePlantBlock.ROTATION, (Comparable)Integer.valueOf(rot));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, state);
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos.func_177984_a(), (BlockState)state.func_206870_a((Property)DoublePlantBlock.TOP, (Comparable)Boolean.valueOf(true)));
        } else if (this.plant instanceof EndCropBlock) {
            BlockState state = (BlockState)this.plant.func_176223_P().func_206870_a((Property)EndCropBlock.AGE, (Comparable)Integer.valueOf(3));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, state);
        } else if (this.plant instanceof PlantBlockWithAge) {
            int age = random.nextInt(4);
            BlockState state = (BlockState)this.plant.func_176223_P().func_206870_a((Property)PlantBlockWithAge.AGE, (Comparable)Integer.valueOf(age));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, state);
        } else {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, this.plant);
        }
    }
}

