/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.util.NbtModIdReplacer;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public abstract class NBTFeature
extends Feature<NoFeatureConfig> {
    public NBTFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    protected abstract Template getStructure(ISeedReader var1, BlockPos var2, Random var3);

    protected abstract boolean canSpawn(ISeedReader var1, BlockPos var2, Random var3);

    protected abstract Rotation getRotation(ISeedReader var1, BlockPos var2, Random var3);

    protected abstract Mirror getMirror(ISeedReader var1, BlockPos var2, Random var3);

    protected abstract int getYOffset(Template var1, ISeedReader var2, BlockPos var3, Random var4);

    protected abstract TerrainMerge getTerrainMerge(ISeedReader var1, BlockPos var2, Random var3);

    protected abstract void addStructureData(PlacementSettings var1);

    protected BlockPos getGround(ISeedReader world, BlockPos center) {
        Biome biome = world.func_226691_t_(center);
        ResourceLocation id = ModBiomes.getBiomeID(biome);
        if (id.func_110624_b().contains("moutain") || id.func_110624_b().contains("lake")) {
            int y = this.getAverageY(world, center);
            return new BlockPos(center.func_177958_n(), y, center.func_177952_p());
        }
        int y = this.getAverageYWG(world, center);
        return new BlockPos(center.func_177958_n(), y, center.func_177952_p());
    }

    protected int getAverageY(ISeedReader world, BlockPos center) {
        int y = FeatureHelper.getYOnSurface(world, center.func_177958_n(), center.func_177952_p());
        y += FeatureHelper.getYOnSurface(world, center.func_177958_n() - 2, center.func_177952_p() - 2);
        y += FeatureHelper.getYOnSurface(world, center.func_177958_n() + 2, center.func_177952_p() - 2);
        y += FeatureHelper.getYOnSurface(world, center.func_177958_n() - 2, center.func_177952_p() + 2);
        return (y += FeatureHelper.getYOnSurface(world, center.func_177958_n() + 2, center.func_177952_p() + 2)) / 5;
    }

    protected int getAverageYWG(ISeedReader world, BlockPos center) {
        int y = FeatureHelper.getYOnSurfaceWG(world, center.func_177958_n(), center.func_177952_p());
        y += FeatureHelper.getYOnSurfaceWG(world, center.func_177958_n() - 2, center.func_177952_p() - 2);
        y += FeatureHelper.getYOnSurfaceWG(world, center.func_177958_n() + 2, center.func_177952_p() - 2);
        y += FeatureHelper.getYOnSurfaceWG(world, center.func_177958_n() - 2, center.func_177952_p() + 2);
        return (y += FeatureHelper.getYOnSurfaceWG(world, center.func_177958_n() + 2, center.func_177952_p() + 2)) / 5;
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos center, NoFeatureConfig config) {
        center = new BlockPos(center.func_177958_n() >> 4 << 4 | 8, 128, center.func_177952_p() >> 4 << 4 | 8);
        if (!this.canSpawn(world, center = this.getGround(world, center), rand)) {
            return false;
        }
        int posY = center.func_177956_o() + 1;
        Template structure = this.getStructure(world, center, rand);
        Rotation rotation = this.getRotation(world, center, rand);
        Mirror mirror = this.getMirror(world, center, rand);
        BlockPos offset = Template.func_207669_a((BlockPos)structure.func_186259_a(), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.field_177992_a);
        center = center.func_177963_a(0.0, (double)this.getYOffset(structure, world, center, rand) + 0.5, 0.0);
        MutableBoundingBox bounds = this.makeBox(center);
        PlacementSettings placementData = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_186223_a(bounds);
        this.addStructureData(placementData);
        center = center.func_177963_a((double)(-offset.func_177958_n()) * 0.5, 0.0, (double)(-offset.func_177952_p()) * 0.5);
        structure.func_237152_b_((IServerWorld)world, center, placementData, rand);
        TerrainMerge merge = this.getTerrainMerge(world, center, rand);
        int x1 = center.func_177958_n();
        int z1 = center.func_177952_p();
        int x2 = x1 + offset.func_177958_n();
        int z2 = z1 + offset.func_177952_p();
        if (merge != TerrainMerge.NONE) {
            int a;
            BlockPos.Mutable mut = new BlockPos.Mutable();
            if (x2 < x1) {
                a = x1;
                x1 = x2;
                x2 = a;
            }
            if (z2 < z1) {
                a = z1;
                z1 = z2;
                z2 = a;
            }
            int surfMax = posY - 1;
            for (int x = x1; x <= x2; ++x) {
                mut.func_223471_o(x);
                block1: for (int z = z1; z <= z2; ++z) {
                    mut.func_223472_q(z);
                    mut.func_185336_p(surfMax);
                    BlockState state = world.func_180495_p((BlockPos)mut);
                    if (state.func_235714_a_(ModTags.GEN_TERRAIN) || !state.func_224755_d((IBlockReader)world, (BlockPos)mut, Direction.DOWN)) continue;
                    for (int i = 0; i < 10; ++i) {
                        ISurfaceBuilderConfig surfaceConfig;
                        mut.func_185336_p(mut.func_177956_o() - 1);
                        BlockState stateSt = world.func_180495_p((BlockPos)mut);
                        if (!stateSt.func_235714_a_(ModTags.GEN_TERRAIN)) {
                            if (merge == TerrainMerge.SURFACE) {
                                surfaceConfig = world.func_226691_t_((BlockPos)mut).func_242440_e().func_242502_e();
                                boolean isTop = mut.func_177956_o() == surfMax && state.func_185904_a().func_76218_k();
                                BlockState top = isTop ? surfaceConfig.func_204108_a() : surfaceConfig.func_204109_b();
                                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, top);
                                continue;
                            }
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
                            continue;
                        }
                        if (!stateSt.func_235714_a_(ModTags.END_GROUND) || !state.func_185904_a().func_76218_k()) continue block1;
                        if (merge == TerrainMerge.SURFACE) {
                            surfaceConfig = world.func_226691_t_((BlockPos)mut).func_242440_e().func_242502_e();
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, surfaceConfig.func_204109_b());
                            continue block1;
                        }
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
                        continue block1;
                    }
                }
            }
        }
        BlockHelper.fixBlocks((IWorld)world, new BlockPos(x1, center.func_177956_o(), z1), new BlockPos(x2, center.func_177956_o() + offset.func_177956_o(), z2));
        return true;
    }

    protected MutableBoundingBox makeBox(BlockPos pos) {
        int sx = (pos.func_177958_n() >> 4 << 4) - 16;
        int sz = (pos.func_177952_p() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return MutableBoundingBox.func_175899_a((int)sx, (int)0, (int)sz, (int)ex, (int)255, (int)ez);
    }

    public static Template readStructure(String path, String replacePath) {
        try {
            InputStream inputstream = MinecraftServer.class.getResourceAsStream(path);
            return NBTFeature.readStructureFromStream(inputstream, replacePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Template readStructure(ResourceLocation resource) {
        String ns = resource.func_110624_b();
        String nm = resource.func_110623_a();
        try {
            InputStream inputstream = MinecraftServer.class.getResourceAsStream("/data/" + ns + "/structures/" + nm + ".nbt");
            return NBTFeature.readStructureFromStream(inputstream, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Template readStructureFromStream(InputStream stream, String replacePath) throws IOException {
        CompoundNBT nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        NbtModIdReplacer.readAndReplace(nbttagcompound, replacePath);
        Template template = new Template();
        template.func_186256_b(nbttagcompound);
        return template;
    }

    public static enum TerrainMerge {
        NONE,
        SURFACE,
        OBJECT;


        public static TerrainMerge getFromString(String type) {
            if (type.equals("surface")) {
                return SURFACE;
            }
            if (type.equals("object")) {
                return OBJECT;
            }
            return NONE;
        }
    }
}

