/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.StructureHelper;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.feature.NBTFeature;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class BiomeNBTStructures
extends NBTFeature {
    private StructureInfo selected;
    private static final HashMap<BetterEndBiome, List<StructureInfo>> nbtStructures = Maps.newHashMap();

    public static void loadStructures() {
        for (BetterEndBiome endBiome : ModBiomes.getModBiomes()) {
            if (endBiome.getNBTStructures().isEmpty()) continue;
            nbtStructures.put(endBiome, endBiome.getNBTStructures());
        }
    }

    @Override
    protected Template getStructure(ISeedReader world, BlockPos pos, Random random) {
        Biome biome = world.func_226691_t_(pos);
        BetterEndBiome endBiome = ModBiomes.getFromBiome(biome);
        List<StructureInfo> biomeStructures = nbtStructures.get(endBiome);
        this.selected = biomeStructures.get(random.nextInt(biomeStructures.size()));
        return this.selected.getStructure();
    }

    @Override
    protected boolean canSpawn(ISeedReader world, BlockPos pos, Random random) {
        int cz;
        if (!nbtStructures.containsKey(ModBiomes.getFromBiome(world.func_226691_t_(pos)))) {
            return false;
        }
        int cx = pos.func_177958_n() >> 4;
        return (cx + (cz = pos.func_177952_p() >> 4) & 1) == 0 && pos.func_177956_o() > 58 && world.func_180495_p(pos.func_177977_b()).func_235714_a_(ModTags.GEN_TERRAIN);
    }

    @Override
    protected Rotation getRotation(ISeedReader world, BlockPos pos, Random random) {
        return Rotation.func_222466_a((Random)random);
    }

    @Override
    protected Mirror getMirror(ISeedReader world, BlockPos pos, Random random) {
        return Mirror.values()[random.nextInt(3)];
    }

    @Override
    protected int getYOffset(Template structure, ISeedReader world, BlockPos pos, Random random) {
        return this.selected.offsetY;
    }

    @Override
    protected NBTFeature.TerrainMerge getTerrainMerge(ISeedReader world, BlockPos pos, Random random) {
        return this.selected.terrainMerge;
    }

    @Override
    protected void addStructureData(PlacementSettings data) {
    }

    public static final class StructureInfo {
        public final NBTFeature.TerrainMerge terrainMerge;
        public final String structurePath;
        public final String replacePath;
        public final int offsetY;
        private Template structure;

        public StructureInfo(String structurePath, String replacePath, int offsetY, NBTFeature.TerrainMerge terrainMerge) {
            this.terrainMerge = terrainMerge;
            this.structurePath = structurePath;
            this.replacePath = replacePath;
            this.offsetY = offsetY;
        }

        public Template getStructure() {
            if (this.structure == null) {
                this.structure = StructureHelper.readStructure(this.structurePath);
            }
            return this.structure;
        }
    }
}

