/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.biome;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BiomeTemplate {
    private static final int DEFAULT_FOLIAGE = ModMathHelper.color(197, 210, 112);
    private final List<StructureFeature<?, ?>> structures = new ArrayList();
    private final List<FeatureInfo> features = Lists.newArrayList();
    private final List<CarverInfo> carvers = Lists.newArrayList();
    private final List<SpawnInfo> mobs = Lists.newArrayList();
    private final List<MobSpawnInfo.Spawners> spawns = Lists.newArrayList();
    private Supplier<ConfiguredSurfaceBuilder<?>> surface;
    private float depth = 0.1f;
    private float scale = 0.2f;
    private float temperature = 2.0f;
    private float downfall = 0.0f;
    private float fogDensity = 1.0f;
    private int fogColor = 0xA080A0;
    private int waterColor = 4159204;
    private int waterFogColor = 329011;
    private int foliageColor = DEFAULT_FOLIAGE;
    private int grassColor = DEFAULT_FOLIAGE;
    private SoundEvent ambient;
    private MoodSoundAmbience mood;
    private SoundAdditionsAmbience additions;
    private SoundEvent music;
    private ParticleEffectAmbience particle;
    private final ResourceLocation id;
    private float genChance = 1.0f;
    private boolean hasCaves = true;
    private boolean isCaveBiome = false;

    public BiomeTemplate(String name) {
        this.id = new ResourceLocation("betterendforge", name);
    }

    public BiomeTemplate setDepth(float depth) {
        this.depth = depth;
        return this;
    }

    public BiomeTemplate setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public BiomeTemplate setTemperature(float temperature) {
        this.temperature = temperature;
        return this;
    }

    public BiomeTemplate setDownfall(float downfall) {
        this.downfall = downfall;
        return this;
    }

    public BiomeTemplate setParticles(IParticleData particle, float probability) {
        this.particle = new ParticleEffectAmbience(particle, probability);
        return this;
    }

    public BiomeTemplate setFogDensity(float density) {
        this.fogDensity = density;
        return this;
    }

    public BiomeTemplate setFogColor(int r, int g, int b) {
        this.fogColor = ModMathHelper.getColor(r, g, b);
        return this;
    }

    public BiomeTemplate setFogColor(int color) {
        this.fogColor = color;
        return this;
    }

    public BiomeTemplate setWaterColor(int r, int g, int b) {
        this.waterColor = ModMathHelper.getColor(r, g, b);
        return this;
    }

    public BiomeTemplate setWaterColor(int color) {
        this.waterColor = color;
        return this;
    }

    public BiomeTemplate setWaterFogColor(int r, int g, int b) {
        this.waterFogColor = ModMathHelper.getColor(r, g, b);
        return this;
    }

    public BiomeTemplate setWaterFogColor(int color) {
        this.waterFogColor = color;
        return this;
    }

    public BiomeTemplate setFoliageColor(int r, int g, int b) {
        this.foliageColor = ModMathHelper.getColor(r, g, b);
        return this;
    }

    public BiomeTemplate setFoliageColor(int color) {
        this.foliageColor = color;
        return this;
    }

    public BiomeTemplate setGrassColor(int r, int g, int b) {
        this.grassColor = ModMathHelper.getColor(r, g, b);
        return this;
    }

    public BiomeTemplate setGrassColor(int color) {
        this.grassColor = color;
        return this;
    }

    public BiomeTemplate setAmbientSound(SoundEvent ambient) {
        this.ambient = ambient;
        return this;
    }

    public BiomeTemplate setMoodSound(SoundEvent mood) {
        this.mood = new MoodSoundAmbience(mood, 6000, 8, 2.0);
        return this;
    }

    public BiomeTemplate setAdditionsSounds(SoundEvent additions) {
        this.additions = new SoundAdditionsAmbience(additions, 0.0111);
        return this;
    }

    public BiomeTemplate setMusic(SoundEvent music) {
        this.music = music;
        return this;
    }

    public BiomeTemplate setCaves(boolean hasCaves) {
        this.hasCaves = hasCaves;
        return this;
    }

    public BiomeTemplate setCaveBiome() {
        this.isCaveBiome = true;
        return this;
    }

    public BiomeTemplate setGenChance(float genChance) {
        this.genChance = genChance;
        return this;
    }

    public BiomeTemplate addMobSpawn(MobSpawnInfo.Spawners entry) {
        this.spawns.add(entry);
        return this;
    }

    public BiomeTemplate addMobSpawn(EntityClassification type, EntityType<?> entity, int weight, int minCount, int maxCount) {
        SpawnInfo info = new SpawnInfo();
        info.type = type;
        info.entity = entity;
        info.weight = weight;
        info.minGroupSize = minCount;
        info.maxGroupSize = maxCount;
        this.mobs.add(info);
        return this;
    }

    public BiomeTemplate setSurface(Block block) {
        this.setSurface(() -> SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(block.func_176223_P(), Blocks.field_150377_bs.func_176223_P(), Blocks.field_150377_bs.func_176223_P())));
        return this;
    }

    public BiomeTemplate setSurface(Supplier<ConfiguredSurfaceBuilder<?>> surface) {
        this.surface = surface;
        return this;
    }

    public BiomeTemplate addStructure(StructureFeature<?, ?> structure) {
        this.structures.add(structure);
        return this;
    }

    public BiomeTemplate addFeature(GenerationStage.Decoration stage, ConfiguredFeature<?, ?> feature) {
        FeatureInfo info = new FeatureInfo();
        info.stage = stage;
        info.feature = feature;
        this.features.add(info);
        return this;
    }

    public BiomeTemplate addCarver(GenerationStage.Carving carverStep, ConfiguredCarver<ProbabilityConfig> carver) {
        CarverInfo info = new CarverInfo();
        info.carverStep = carverStep;
        info.carver = carver;
        this.carvers.add(info);
        return this;
    }

    public Biome build() {
        BiomeAmbience.Builder effects = new BiomeAmbience.Builder();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder();
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        for (SpawnInfo spawnInfo : this.mobs) {
            spawnSettings.func_242575_a(spawnInfo.type, new MobSpawnInfo.Spawners(spawnInfo.entity, spawnInfo.weight, spawnInfo.minGroupSize, spawnInfo.maxGroupSize));
        }
        this.spawns.forEach(entry -> spawnSettings.func_242575_a(entry.field_242588_c.func_220339_d(), entry));
        if (this.surface != null) {
            generationSettings.func_242519_a(this.surface);
        } else {
            generationSettings.func_242517_a(ConfiguredSurfaceBuilders.field_244173_e);
        }
        for (CarverInfo carverInfo : this.carvers) {
            generationSettings.func_242512_a(carverInfo.carverStep, carverInfo.carver);
        }
        for (FeatureInfo featureInfo : this.features) {
            generationSettings.func_242513_a(featureInfo.stage, featureInfo.feature);
        }
        for (StructureFeature structureFeature : this.structures) {
            generationSettings.func_242516_a(structureFeature);
        }
        effects.func_242539_d(0).func_235248_c_(this.waterFogColor).func_235246_b_(this.waterColor).func_235239_a_(this.fogColor).func_242540_e(this.foliageColor).func_242541_f(this.grassColor);
        if (this.ambient != null) {
            effects.func_235241_a_(this.ambient);
        }
        if (this.mood != null) {
            effects.func_235243_a_(this.mood);
        }
        if (this.additions != null) {
            effects.func_235242_a_(this.additions);
        }
        if (this.music != null) {
            effects.func_235240_a_(new BackgroundMusicSelector(this.music, 600, 2400, true));
        } else {
            effects.func_235240_a_(BackgroundMusicTracks.field_232674_e_);
        }
        if (this.particle != null) {
            effects.func_235244_a_(this.particle);
        }
        return new Biome.Builder().func_205419_a(this.isCaveBiome ? Biome.Category.NONE : Biome.Category.THEEND).func_205415_a(Biome.RainType.NONE).func_205421_a(this.depth).func_205420_b(this.scale).func_205414_c(this.temperature).func_242456_a(Biome.TemperatureModifier.NONE).func_205417_d(this.downfall).func_235097_a_(effects.func_235238_a_()).func_242457_a(generationSettings.func_242508_a()).func_242458_a(spawnSettings.func_242577_b()).func_242455_a();
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    public float getGenChance() {
        return this.genChance;
    }

    public boolean hasCaves() {
        return this.hasCaves;
    }

    private static final class CarverInfo {
        GenerationStage.Carving carverStep;
        ConfiguredCarver<ProbabilityConfig> carver;

        private CarverInfo() {
        }
    }

    private static final class FeatureInfo {
        GenerationStage.Decoration stage;
        ConfiguredFeature<?, ?> feature;

        private FeatureInfo() {
        }
    }

    private static final class SpawnInfo {
        EntityClassification type;
        EntityType<?> entity;
        int weight;
        int minGroupSize;
        int maxGroupSize;

        private SpawnInfo() {
        }
    }
}

