/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.particles;

import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SulphurParticle
extends SpriteTexturedParticle {
    private int ticks;
    private double preVX;
    private double preVY;
    private double preVZ;
    private double nextVX;
    private double nextVY;
    private double nextVZ;

    protected SulphurParticle(ClientWorld world, double x, double y, double z, double r, double g, double b, IAnimatedSprite spriteWithAge) {
        super(world, x, y, z, r, g, b);
        this.func_217566_b(spriteWithAge);
        this.field_70547_e = ModMathHelper.randRange(150, 300, this.field_187136_p);
        this.field_70544_f = ModMathHelper.randRange(0.05f, 0.15f, this.field_187136_p);
        this.func_70538_b(1.0f, 1.0f, 1.0f);
        this.field_82339_as = 0.0f;
        this.preVX = this.field_187136_p.nextGaussian() * 0.015;
        this.preVY = this.field_187136_p.nextGaussian() * 0.015;
        this.preVZ = this.field_187136_p.nextGaussian() * 0.015;
        this.nextVX = this.field_187136_p.nextGaussian() * 0.015;
        this.nextVY = this.field_187136_p.nextGaussian() * 0.015;
        this.nextVZ = this.field_187136_p.nextGaussian() * 0.015;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public void func_189213_a() {
        ++this.ticks;
        if (this.ticks > 200) {
            this.preVX = this.nextVX;
            this.preVY = this.nextVY;
            this.preVZ = this.nextVZ;
            this.nextVX = this.field_187136_p.nextGaussian() * 0.015;
            this.nextVY = this.field_187136_p.nextGaussian() * 0.015;
            this.nextVZ = this.field_187136_p.nextGaussian() * 0.015;
            if (this.field_187136_p.nextInt(4) == 0) {
                this.nextVY = Math.abs(this.nextVY);
            }
            this.ticks = 0;
        }
        double delta = (double)this.ticks / 200.0;
        if (this.field_70546_d <= 40) {
            this.func_82338_g((float)this.field_70546_d / 40.0f);
        } else if (this.field_70546_d >= this.field_70547_e - 40) {
            this.func_82338_g((float)(this.field_70547_e - this.field_70546_d) / 40.0f);
        }
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187129_i = MathHelper.func_219803_d((double)delta, (double)this.preVX, (double)this.nextVX);
        this.field_187130_j = MathHelper.func_219803_d((double)delta, (double)this.preVY, (double)this.nextVY);
        this.field_187131_k = MathHelper.func_219803_d((double)delta, (double)this.preVZ, (double)this.nextVZ);
        super.func_189213_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite sprite;

        public Factory(IAnimatedSprite sprite) {
            this.sprite = sprite;
        }

        public Particle makeParticle(BasicParticleType type, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SulphurParticle(worldIn, x, y, z, 1.0, 1.0, 1.0, this.sprite);
        }
    }
}

