/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import mod.beethoven92.betterendforge.client.model.CrystaliteBootsModel;
import mod.beethoven92.betterendforge.client.model.CrystaliteChestplateModel;
import mod.beethoven92.betterendforge.client.model.CrystaliteHelmetModel;
import mod.beethoven92.betterendforge.client.model.CrystaliteLeggingsModel;
import mod.beethoven92.betterendforge.common.init.ModAttributes;
import mod.beethoven92.betterendforge.common.init.ModItems;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrystaliteArmor
extends ArmorItem {
    private static final UUID[] UUIDS = new UUID[]{UUID.fromString("38c9722b-d905-4b84-940d-551c803100af"), UUID.fromString("a7bab7bb-9f3b-4787-9ff7-f138c9c17f6c"), UUID.fromString("ccf857e1-86e3-40d5-9f51-fe624d54cc33"), UUID.fromString("ed88885e-1882-4989-a4b3-8aa32e2b02d3")};
    @OnlyIn(value=Dist.CLIENT)
    CrystaliteBootsModel bootsModel;
    @OnlyIn(value=Dist.CLIENT)
    CrystaliteChestplateModel slimChestplateModel;
    @OnlyIn(value=Dist.CLIENT)
    CrystaliteChestplateModel chestplateModel;
    @OnlyIn(value=Dist.CLIENT)
    CrystaliteHelmetModel helmetModel;
    @OnlyIn(value=Dist.CLIENT)
    CrystaliteLeggingsModel leggingsModel;

    public CrystaliteArmor(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        Multimap modifiers = super.func_111205_h(equipmentSlot);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(modifiers);
        Item item = stack.func_77973_b();
        if (item == ModItems.CRYSTALITE_HELMET.get() && equipmentSlot == EquipmentSlotType.HEAD) {
            builder.put((Object)ModAttributes.BLINDNESS_RESISTANCE.get(), (Object)new AttributeModifier(UUIDS[equipmentSlot.func_188454_b()], "Helmet blindness resistance", 1.0, AttributeModifier.Operation.ADDITION));
        } else if (item == ModItems.CRYSTALITE_LEGGINGS.get() && equipmentSlot == EquipmentSlotType.LEGS) {
            builder.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(UUIDS[equipmentSlot.func_188454_b()], "Armor health boost", 4.0, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (player.field_70173_aa % 60 == 0) {
            Item item = stack.func_77973_b();
            if (item == ModItems.CRYSTALITE_BOOTS.get()) {
                player.func_195064_c(new EffectInstance(Effects.field_76424_c, 80, 0, true, false, true));
            } else if (item == ModItems.CRYSTALITE_CHESTPLATE.get()) {
                player.func_195064_c(new EffectInstance(Effects.field_76422_e, 80, 0, true, false, true));
            }
            if (this.hasFullSet(player)) {
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 80, 0, true, false, true));
            }
        }
    }

    private boolean hasFullSet(PlayerEntity player) {
        for (ItemStack armorStack : player.func_184193_aE()) {
            if (armorStack.func_77973_b() instanceof CrystaliteArmor) continue;
            return false;
        }
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "betterendforge:textures/models/armor/crystalite_layer_" + (slot == EquipmentSlotType.LEGS ? "2" : "1") + ".png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (this.bootsModel == null) {
            this.bootsModel = new CrystaliteBootsModel(1.0f);
            this.chestplateModel = new CrystaliteChestplateModel(1.0f, false);
            this.slimChestplateModel = new CrystaliteChestplateModel(1.0f, true);
            this.helmetModel = new CrystaliteHelmetModel(1.0f);
            this.leggingsModel = new CrystaliteLeggingsModel(1.0f);
        }
        switch (this.field_77881_a) {
            case HEAD: {
                return (A)((Object)this.helmetModel);
            }
            case CHEST: {
                if (entityLiving instanceof AbstractClientPlayerEntity && ((AbstractClientPlayerEntity)entityLiving).func_175154_l().equals("slim")) {
                    return (A)((Object)this.slimChestplateModel);
                }
                return (A)((Object)this.chestplateModel);
            }
            case LEGS: {
                return (A)((Object)this.leggingsModel);
            }
            case FEET: {
                return (A)((Object)this.bootsModel);
            }
        }
        return _default;
    }
}

