/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.render.buffer.DelegateRenderType;
import codechicken.lib.vec.Matrix4;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexFormat;
import org.lwjgl.opengl.GL15;

public class VBORenderType
extends DelegateRenderType {
    private final BiConsumer<VertexFormat, BufferBuilder> factory;
    private int bufferId = -1;
    private int count;

    public VBORenderType(RenderType parent, BiConsumer<VertexFormat, BufferBuilder> factory) {
        this(parent, parent.func_228663_p_(), factory);
    }

    public VBORenderType(RenderType parent, VertexFormat bufferFormat, BiConsumer<VertexFormat, BufferBuilder> factory) {
        super(parent, bufferFormat);
        this.factory = factory;
    }

    public void rebuild() {
        if (this.bufferId == -1) {
            this.bufferId = GL15.glGenBuffers();
        }
        BufferBuilder builder = new BufferBuilder(this.func_228662_o_());
        builder.func_181668_a(this.func_228664_q_(), this.func_228663_p_());
        this.factory.accept(this.func_228663_p_(), builder);
        builder.func_178977_d();
        Pair pair = builder.func_227832_f_();
        ByteBuffer buffer = (ByteBuffer)pair.getSecond();
        this.count = buffer.remaining() / this.func_228663_p_().func_177338_f();
        GL15.glBindBuffer((int)34962, (int)this.bufferId);
        GL15.glBufferData((int)34962, (ByteBuffer)buffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public MatrixVBORenderType withMatrix(Matrix4 matrix) {
        return new MatrixVBORenderType(this, matrix);
    }

    private void render() {
        if (this.bufferId == -1) {
            this.rebuild();
        }
        GL15.glBindBuffer((int)34962, (int)this.bufferId);
        this.func_228663_p_().func_227892_a_(0L);
        GL15.glDrawArrays((int)this.func_228664_q_(), (int)0, (int)this.count);
        this.func_228663_p_().func_227895_d_();
        GL15.glBindBuffer((int)34962, (int)0);
    }

    @Override
    public void func_228631_a_(BufferBuilder buffer, int cameraX, int cameraY, int cameraZ) {
        buffer.func_178977_d();
        buffer.func_227832_f_();
        this.func_228547_a_();
        this.render();
        this.func_228549_b_();
    }

    public static class MatrixVBORenderType
    extends DelegateRenderType {
        private final LinkedList<RenderState> states = new LinkedList();
        private final VBORenderType parent;
        private final Matrix4 matrix;
        private boolean hasLightMap = false;
        private int packedLight;

        public MatrixVBORenderType(VBORenderType parent, Matrix4 matrix) {
            super(parent);
            this.parent = parent;
            this.matrix = matrix.copy();
        }

        public MatrixVBORenderType withLightMap(int packedLight) {
            this.hasLightMap = true;
            this.packedLight = packedLight;
            return this;
        }

        public MatrixVBORenderType withState(RenderState state) {
            this.states.add(state);
            return this;
        }

        @Override
        public void func_228547_a_() {
            super.func_228547_a_();
            this.states.forEach(RenderState::func_228547_a_);
            RenderSystem.pushMatrix();
            this.matrix.glApply();
            if (this.hasLightMap) {
                RenderSystem.glMultiTexCoord2f((int)33986, (float)(this.packedLight & 0xFFFF), (float)(this.packedLight >>> 16));
            }
        }

        @Override
        public void func_228631_a_(BufferBuilder buffer, int cameraX, int cameraY, int cameraZ) {
            buffer.func_178977_d();
            buffer.func_227832_f_();
            this.func_228547_a_();
            this.parent.render();
            this.func_228549_b_();
        }

        @Override
        public void func_228549_b_() {
            RenderSystem.popMatrix();
            this.states.forEach(RenderState::func_228549_b_);
            super.func_228549_b_();
        }

        public boolean equals(Object other) {
            return other == this;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }
}

