/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Int2ObjectMap<ICustomPacketHandler.IClientPacketHandler> handlers = new Int2ObjectArrayMap();

    public void addHandler(int id, ICustomPacketHandler.IClientPacketHandler handler) {
        if (handlers.containsKey(id)) {
            throw new IllegalArgumentException("Handler already registered for ID: " + id);
        }
        handlers.put(id, (Object)handler);
    }

    @Override
    public void handlePacket(PacketCustom packet, Minecraft mc, IClientPlayNetHandler handler) {
        ICustomPacketHandler.IClientPacketHandler h = (ICustomPacketHandler.IClientPacketHandler)handlers.get(packet.getType());
        if (h != null) {
            h.handlePacket(packet, mc, handler);
        } else {
            LOGGER.warn("Received unknown packet on channel '{}' with descriptor '{}'.", (Object)packet.getChannel(), (Object)packet.getType());
        }
    }
}

