/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters;

import com.tmtravlr.soundfilters.SoundFiltersMod;
import com.tmtravlr.soundfilters.handlers.FilterHandler;
import com.tmtravlr.soundfilters.handlers.LiquidLowPassHandler;
import com.tmtravlr.soundfilters.handlers.OcclusionHandler;
import com.tmtravlr.soundfilters.handlers.ReverbHandler;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SoundEventHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static boolean hasLoadedFirstTime = false;
    public static Map<ISound, ChannelManager.Entry> playingSoundsChannel = null;

    @SubscribeEvent
    public static void onSoundPlaying(SoundEvent.SoundSourceEvent event) {
        if (SoundEventHandler.MC.field_71441_e != null) {
            try {
                int sourceId = (Integer)ObfuscationReflectionHelper.getPrivateValue(SoundSource.class, (Object)event.getSource(), (String)"field_216441_b");
                FilterHandler.SOURCE_IDS.put(event.getSound(), sourceId);
            }
            catch (Exception e) {
                SoundFiltersMod.LOGGER.warn("Caught an error while trying to handle the sound '" + event.getName() + "'. Filters will not be applied to it.", (Throwable)e);
            }
            if (SoundEventHandler.MC.field_71439_g != null && event.getSound().func_147656_j() != ISound.AttenuationType.NONE && !event.getSound().func_217861_m()) {
                OcclusionHandler.addOcclusionToMap(event.getSound());
            }
            if (!event.getSource().func_216435_g()) {
                FilterHandler.updateSourceFilters(event.getSound());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (!hasLoadedFirstTime) {
                hasLoadedFirstTime = true;
                SoundEventHandler.loadSoundChannels();
            }
            if (playingSoundsChannel != null) {
                if (SoundEventHandler.MC.field_71441_e != null && SoundEventHandler.MC.field_71439_g != null && !MC.func_147113_T()) {
                    LiquidLowPassHandler.updateLiquidLowPass();
                    ReverbHandler.updateReverb();
                    OcclusionHandler.updateOcclusion();
                } else {
                    LiquidLowPassHandler.stopLiquidLowPass();
                    ReverbHandler.stopReverb();
                }
                SoundEventHandler.updateFilters();
            }
        }
    }

    private static void loadSoundChannels() {
        try {
            SoundEngine soundEngine = (SoundEngine)ObfuscationReflectionHelper.getPrivateValue(SoundHandler.class, (Object)Minecraft.func_71410_x().func_147118_V(), (String)"field_147694_f");
            playingSoundsChannel = (Map)ObfuscationReflectionHelper.getPrivateValue(SoundEngine.class, (Object)soundEngine, (String)"field_217942_m");
            SoundFiltersMod.LOGGER.info("Sound Filters successfully loaded the sound channels");
        }
        catch (Exception e) {
            SoundFiltersMod.LOGGER.error("Sound Filters wasn't able to load the sound channels. The sound filters will no longer work.", (Throwable)e);
        }
    }

    private static void updateFilters() {
        playingSoundsChannel.forEach((sound, entry) -> entry.func_217888_a(source -> {
            if (!source.func_216435_g()) {
                FilterHandler.updateSourceFilters(sound);
            }
        }));
        FilterHandler.SOURCE_IDS.entrySet().removeIf(entry -> !playingSoundsChannel.containsKey(entry.getKey()));
    }
}

