/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.init;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitles;
import com.yungnickyoung.minecraft.travelerstitles.config.TTConfig;
import com.yungnickyoung.minecraft.travelerstitles.init.TTModClient;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class TTModConfig {
    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, TTConfig.SPEC, "travelerstitles-forge-1_16.toml");
        MinecraftForge.EVENT_BUS.addListener(TTModConfig::onWorldLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TTModConfig::configChanged);
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        TTModConfig.reloadConfig();
    }

    public static void configChanged(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == TTConfig.SPEC) {
            TTModConfig.reloadConfig();
        }
    }

    private static void reloadConfig() {
        TTModClient.biomeTitleRenderer.maxRecentListSize = (Integer)TTConfig.biomes.recentBiomeCacheSize.get();
        TTModClient.biomeTitleRenderer.enabled = (Boolean)TTConfig.biomes.enabled.get();
        TTModClient.biomeTitleRenderer.titleFadeInTicks = (Integer)TTConfig.biomes.textFadeInTime.get();
        TTModClient.biomeTitleRenderer.titleDisplayTime = (Integer)TTConfig.biomes.textDisplayTime.get();
        TTModClient.biomeTitleRenderer.titleFadeOutTicks = (Integer)TTConfig.biomes.textFadeOutTime.get();
        TTModClient.biomeTitleRenderer.titleDefaultTextColor = (String)TTConfig.biomes.textColor.get();
        TTModClient.biomeTitleRenderer.showTextShadow = (Boolean)TTConfig.biomes.renderShadow.get();
        TTModClient.biomeTitleRenderer.titleTextSize = ((Double)TTConfig.biomes.textSize.get()).floatValue();
        TTModClient.biomeTitleRenderer.titleXOffset = ((Double)TTConfig.biomes.textXOffset.get()).floatValue();
        TTModClient.biomeTitleRenderer.titleYOffset = ((Double)TTConfig.biomes.textYOffset.get()).floatValue();
        TTModClient.biomeTitleRenderer.isTextCentered = (Boolean)TTConfig.biomes.centerText.get();
        TTModClient.dimensionTitleRenderer.enabled = (Boolean)TTConfig.dimensions.enabled.get();
        TTModClient.dimensionTitleRenderer.titleFadeInTicks = (Integer)TTConfig.dimensions.textFadeInTime.get();
        TTModClient.dimensionTitleRenderer.titleDisplayTime = (Integer)TTConfig.dimensions.textDisplayTime.get();
        TTModClient.dimensionTitleRenderer.titleFadeOutTicks = (Integer)TTConfig.dimensions.textFadeOutTime.get();
        TTModClient.dimensionTitleRenderer.titleDefaultTextColor = (String)TTConfig.dimensions.textColor.get();
        TTModClient.dimensionTitleRenderer.showTextShadow = (Boolean)TTConfig.dimensions.renderShadow.get();
        TTModClient.dimensionTitleRenderer.titleTextSize = ((Double)TTConfig.dimensions.textSize.get()).floatValue();
        TTModClient.dimensionTitleRenderer.titleXOffset = ((Double)TTConfig.dimensions.textXOffset.get()).floatValue();
        TTModClient.dimensionTitleRenderer.titleYOffset = ((Double)TTConfig.dimensions.textYOffset.get()).floatValue();
        TTModClient.dimensionTitleRenderer.isTextCentered = (Boolean)TTConfig.dimensions.centerText.get();
        String rawStringofList = (String)TTConfig.biomes.biomeBlacklist.get();
        int strLen = rawStringofList.length();
        if (strLen < 2 || rawStringofList.charAt(0) != '[' || rawStringofList.charAt(strLen - 1) != ']') {
            TravelersTitles.LOGGER.error("INVALID VALUE FOR SETTING 'Blacklisted Biomes'. Using empty list instead...");
            TTModClient.blacklistedBiomes = new ArrayList<String>();
            return;
        }
        ArrayList inputListOfStrings = Lists.newArrayList((Object[])rawStringofList.substring(1, strLen - 1).split(",\\s*"));
        TTModClient.blacklistedBiomes = Lists.newArrayList((Iterable)inputListOfStrings);
        rawStringofList = (String)TTConfig.dimensions.dimensionBlacklist.get();
        strLen = rawStringofList.length();
        if (strLen < 2 || rawStringofList.charAt(0) != '[' || rawStringofList.charAt(strLen - 1) != ']') {
            TravelersTitles.LOGGER.error("INVALID VALUE FOR SETTING 'Blacklisted Dimensions'. Using empty list instead...");
            TTModClient.blacklistedDimensions = new ArrayList<String>();
            return;
        }
        inputListOfStrings = Lists.newArrayList((Object[])rawStringofList.substring(1, strLen - 1).split(",\\s*"));
        TTModClient.blacklistedDimensions = Lists.newArrayList((Iterable)inputListOfStrings);
    }
}

