/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModProcessors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

@MethodsReturnNonnullByDefault
public class MobSpawnerProcessor
extends StructureProcessor {
    public static final Codec<MobSpawnerProcessor> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)ResourceLocation.field_240908_a_.fieldOf("spawner_mob").forGetter(MobSpawnerProcessor::getSpawnerMob)).apply((Applicative)codecBuilder, codecBuilder.stable(MobSpawnerProcessor::new)));
    private final ResourceLocation spawnerMob;

    private MobSpawnerProcessor(ResourceLocation spawnerMob) {
        this.spawnerMob = spawnerMob;
    }

    public ResourceLocation getSpawnerMob() {
        return this.spawnerMob;
    }

    @ParametersAreNonnullByDefault
    public Template.BlockInfo process(IWorldReader worldReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, Template.BlockInfo blockInfoLocal, Template.BlockInfo blockInfoGlobal, PlacementSettings structurePlacementData, @Nullable Template template) {
        if (blockInfoGlobal.field_186243_b.func_177230_c() instanceof SpawnerBlock) {
            CompoundNBT spawnData = new CompoundNBT();
            spawnData.func_74778_a("id", this.spawnerMob.toString());
            blockInfoGlobal.field_186244_c.func_82580_o("SpawnData");
            blockInfoGlobal.field_186244_c.func_218657_a("SpawnData", (INBT)spawnData);
            CompoundNBT spawnPotentials = new CompoundNBT();
            CompoundNBT spawnPotentialsEntity = new CompoundNBT();
            spawnPotentialsEntity.func_74778_a("id", this.spawnerMob.toString());
            spawnPotentials.func_218657_a("Entity", (INBT)spawnPotentialsEntity);
            spawnPotentials.func_218657_a("Weight", (INBT)IntNBT.func_229692_a_((int)1));
            blockInfoGlobal.field_186244_c.func_150295_c("SpawnPotentials", (int)spawnPotentials.func_74732_a()).clear();
            blockInfoGlobal.field_186244_c.func_150295_c("SpawnPotentials", (int)spawnPotentials.func_74732_a()).add(0, (INBT)spawnPotentials);
        }
        return blockInfoGlobal;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BDModProcessors.MOB_SPAWNER_PROCESSOR;
    }
}

