/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures.piece;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.world.structures.piece.CustomPiece;
import someoneelse.betternetherreforged.world.structures.piece.StructureTypes;

public class DestructionPiece
extends CustomPiece {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private BlockPos center;
    private int radius;
    private int radSqr;
    private int minY;
    private int maxY;

    public DestructionPiece(MutableBoundingBox bounds, Random random) {
        super(StructureTypes.DESTRUCTION, random.nextInt());
        this.radius = random.nextInt(5) + 1;
        this.radSqr = this.radius * this.radius;
        this.center = new BlockPos(MHelper.randRange(bounds.field_78897_a, bounds.field_78893_d, random), MHelper.randRange(bounds.field_78895_b, bounds.field_78894_e, random), MHelper.randRange(bounds.field_78896_c, bounds.field_78892_f, random));
        this.makeBoundingBox();
    }

    protected DestructionPiece(TemplateManager manager, CompoundNBT tag) {
        super(StructureTypes.DESTRUCTION, tag);
        this.center = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("center"));
        this.radius = tag.func_74762_e("radius");
        this.radSqr = this.radius * this.radius;
        this.makeBoundingBox();
    }

    protected void func_143011_b(CompoundNBT tag) {
        tag.func_218657_a("center", (INBT)NBTUtil.func_186859_a((BlockPos)this.center));
        tag.func_74768_a("radius", this.radius);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        for (int x = blockBox.field_78897_a; x <= blockBox.field_78893_d; ++x) {
            int px = x - this.center.func_177958_n();
            px *= px;
            for (int z = blockBox.field_78896_c; z <= blockBox.field_78892_f; ++z) {
                int pz = z - this.center.func_177952_p();
                pz *= pz;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    int py = y - this.center.func_177956_o() << 1;
                    if (px + (py *= py) + pz > this.radSqr + random.nextInt(this.radius)) continue;
                    POS.func_181079_c(x, y, z);
                    if (world.func_175623_d((BlockPos)POS)) continue;
                    if (random.nextBoolean()) {
                        BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, field_202556_l);
                        continue;
                    }
                    int dist = BlocksHelper.downRay((IWorld)world, (BlockPos)POS, this.maxY - 5);
                    if (dist <= 0) continue;
                    BlockState state = world.func_180495_p((BlockPos)POS);
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, field_202556_l);
                    POS.func_185336_p(POS.func_177956_o() - dist);
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, state);
                }
            }
        }
        return true;
    }

    private void makeBoundingBox() {
        int x1 = this.center.func_177958_n() - this.radius;
        int x2 = this.center.func_177958_n() + this.radius;
        this.minY = Math.max(22, this.center.func_177956_o() - this.radius);
        if (this.minY < 38) {
            this.minY = 38;
        }
        this.maxY = Math.min(96, this.center.func_177956_o() + this.radius);
        int z1 = this.center.func_177952_p() - this.radius;
        int z2 = this.center.func_177952_p() + this.radius;
        this.field_74887_e = new MutableBoundingBox(x1, this.minY, z1, x2, this.maxY, z2);
    }
}

