/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures.city.palette;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import someoneelse.betternetherreforged.blocks.BlockPottedPlant;
import someoneelse.betternetherreforged.blocks.BlockSmallLantern;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class CityPalette {
    private static final Random RANDOM = new Random();
    private final String name;
    private final List<Block> foundationBlocks = new ArrayList<Block>();
    private final List<Block> foundationSlabs = new ArrayList<Block>();
    private final List<Block> foundationStairs = new ArrayList<Block>();
    private final List<Block> foundationWalls = new ArrayList<Block>();
    private final List<Block> roofBlocks = new ArrayList<Block>();
    private final List<Block> roofSlabs = new ArrayList<Block>();
    private final List<Block> roofStairs = new ArrayList<Block>();
    private final List<Block> planksBlocks = new ArrayList<Block>();
    private final List<Block> planksSlabs = new ArrayList<Block>();
    private final List<Block> planksStairs = new ArrayList<Block>();
    private final List<Block> fences = new ArrayList<Block>();
    private final List<Block> walls = new ArrayList<Block>();
    private final List<Block> gates = new ArrayList<Block>();
    private final List<Block> logs = new ArrayList<Block>();
    private final List<Block> bark = new ArrayList<Block>();
    private final List<Block> stoneBlocks = new ArrayList<Block>();
    private final List<Block> stoneSlabs = new ArrayList<Block>();
    private final List<Block> stoneStairs = new ArrayList<Block>();
    private final List<Block> glowingBlocks = new ArrayList<Block>();
    private final List<Block> wallLights = new ArrayList<Block>();
    private final List<Block> ceilingLights = new ArrayList<Block>();
    private final List<Block> floorLights = new ArrayList<Block>();
    private final List<Block> doors = new ArrayList<Block>();
    private final List<Block> trapdoors = new ArrayList<Block>();
    private final List<Block> platesStone = new ArrayList<Block>();
    private final List<Block> platesWood = new ArrayList<Block>();
    private final List<Block> glassBlocks = new ArrayList<Block>();
    private final List<Block> glassPanes = new ArrayList<Block>();
    private final List<Block> pots = new ArrayList<Block>();

    public CityPalette(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private CityPalette putBlocks(Block[] blocks, List<Block> list) {
        for (Block b : blocks) {
            list.add(b);
        }
        return this;
    }

    public CityPalette addFoundationBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationBlocks);
    }

    public CityPalette addFoundationSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationSlabs);
    }

    public CityPalette addFoundationStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationStairs);
    }

    public CityPalette addFoundationWalls(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationWalls);
    }

    public CityPalette addRoofBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.roofBlocks);
    }

    public CityPalette addRoofSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.roofSlabs);
    }

    public CityPalette addRoofStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.roofStairs);
    }

    public CityPalette addPlanksBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.planksBlocks);
    }

    public CityPalette addPlanksSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.planksSlabs);
    }

    public CityPalette addPlanksStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.planksStairs);
    }

    public CityPalette addFences(Block ... blocks) {
        return this.putBlocks(blocks, this.fences);
    }

    public CityPalette addWalls(Block ... blocks) {
        return this.putBlocks(blocks, this.walls);
    }

    public CityPalette addGates(Block ... blocks) {
        return this.putBlocks(blocks, this.gates);
    }

    public CityPalette addLogs(Block ... blocks) {
        return this.putBlocks(blocks, this.logs);
    }

    public CityPalette addBark(Block ... blocks) {
        return this.putBlocks(blocks, this.bark);
    }

    public CityPalette addStoneBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneBlocks);
    }

    public CityPalette addStoneSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneSlabs);
    }

    public CityPalette addStoneStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneStairs);
    }

    public CityPalette addGlowingBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.glowingBlocks);
    }

    public CityPalette addWallLights(Block ... blocks) {
        return this.putBlocks(blocks, this.wallLights);
    }

    public CityPalette addCeilingLights(Block ... blocks) {
        return this.putBlocks(blocks, this.ceilingLights);
    }

    public CityPalette addFloorLights(Block ... blocks) {
        return this.putBlocks(blocks, this.floorLights);
    }

    public CityPalette addDoors(Block ... blocks) {
        return this.putBlocks(blocks, this.doors);
    }

    public CityPalette addTrapdoors(Block ... blocks) {
        return this.putBlocks(blocks, this.trapdoors);
    }

    public CityPalette addStonePlates(Block ... blocks) {
        return this.putBlocks(blocks, this.platesStone);
    }

    public CityPalette addWoodPlates(Block ... blocks) {
        return this.putBlocks(blocks, this.platesWood);
    }

    public CityPalette addGlassBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.glassBlocks);
    }

    public CityPalette addGlassPanes(Block ... blocks) {
        return this.putBlocks(blocks, this.glassPanes);
    }

    public CityPalette addPotsPanes(Block ... blocks) {
        return this.putBlocks(blocks, this.pots);
    }

    private Block getRandomBlock(BlockState state, List<Block> list) {
        if (list.isEmpty()) {
            return state.func_177230_c();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        String seed = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)state.func_177230_c()).func_110623_a();
        RANDOM.setSeed(seed.hashCode());
        return list.get(RANDOM.nextInt(list.size()));
    }

    private BlockState getFullState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return list.get(0).func_176223_P();
        }
        return this.getRandomBlock(input, list).func_176223_P();
    }

    private BlockState getSlabState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copySlab(input, list.get(0));
        }
        return this.copySlab(input, this.getRandomBlock(input, list));
    }

    private BlockState getStairState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copyStair(input, list.get(0));
        }
        return this.copyStair(input, this.getRandomBlock(input, list));
    }

    private BlockState copySlab(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, source.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SlabBlock.field_204512_b, source.func_177229_b((Property)SlabBlock.field_204512_b));
        return state;
    }

    private BlockState copyStair(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, source.func_177229_b((Property)StairsBlock.field_176309_a))).func_206870_a((Property)StairsBlock.field_176308_b, source.func_177229_b((Property)StairsBlock.field_176308_b))).func_206870_a((Property)StairsBlock.field_176310_M, source.func_177229_b((Property)StairsBlock.field_176310_M))).func_206870_a((Property)StairsBlock.field_204513_t, source.func_177229_b((Property)StairsBlock.field_204513_t));
        return state;
    }

    private BlockState copyWall(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)WallBlock.field_235612_b_, source.func_177229_b((Property)WallBlock.field_235612_b_))).func_206870_a((Property)WallBlock.field_235613_c_, source.func_177229_b((Property)WallBlock.field_235613_c_))).func_206870_a((Property)WallBlock.field_235614_d_, source.func_177229_b((Property)WallBlock.field_235614_d_))).func_206870_a((Property)WallBlock.field_235615_e_, source.func_177229_b((Property)WallBlock.field_235615_e_))).func_206870_a((Property)WallBlock.field_176256_a, source.func_177229_b((Property)WallBlock.field_176256_a))).func_206870_a((Property)StairsBlock.field_204513_t, source.func_177229_b((Property)StairsBlock.field_204513_t));
        return state;
    }

    private BlockState copyFence(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)FenceBlock.field_196411_b, source.func_177229_b((Property)FenceBlock.field_196411_b))).func_206870_a((Property)FenceBlock.field_196409_a, source.func_177229_b((Property)FenceBlock.field_196409_a))).func_206870_a((Property)FenceBlock.field_196413_c, source.func_177229_b((Property)FenceBlock.field_196413_c))).func_206870_a((Property)FenceBlock.field_196414_y, source.func_177229_b((Property)FenceBlock.field_196414_y))).func_206870_a((Property)FenceBlock.field_204514_u, source.func_177229_b((Property)FenceBlock.field_204514_u));
        return state;
    }

    private BlockState copyGate(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)FenceGateBlock.field_176467_M, source.func_177229_b((Property)FenceGateBlock.field_176467_M))).func_206870_a((Property)FenceGateBlock.field_176466_a, source.func_177229_b((Property)FenceGateBlock.field_176466_a))).func_206870_a((Property)FenceGateBlock.field_176465_b, source.func_177229_b((Property)FenceGateBlock.field_176465_b))).func_206870_a((Property)FenceGateBlock.field_185512_D, source.func_177229_b((Property)FenceGateBlock.field_185512_D));
        return state;
    }

    private BlockState copyPillar(BlockState source, Block block) {
        BlockState state = (BlockState)block.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, source.func_177229_b((Property)RotatedPillarBlock.field_176298_M));
        return state;
    }

    private BlockState copyLanternWall(BlockState source, Block block) {
        if (source.func_177230_c() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            Direction facing = (Direction)source.func_177229_b((Property)BlockSmallLantern.FACING);
            BlockState state = block.func_176223_P();
            if (block instanceof WallTorchBlock) {
                return (BlockState)state.func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)facing);
            }
            return state;
        }
        return source;
    }

    private BlockState copyLanternCeiling(BlockState source, Block block) {
        if (source.func_177230_c() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            BlockState state = block.func_176223_P();
            if (block instanceof LanternBlock) {
                return (BlockState)state.func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return source;
    }

    private BlockState copyDoor(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)DoorBlock.field_176520_a, source.func_177229_b((Property)DoorBlock.field_176520_a))).func_206870_a((Property)DoorBlock.field_176523_O, source.func_177229_b((Property)DoorBlock.field_176523_O))).func_206870_a((Property)DoorBlock.field_176521_M, source.func_177229_b((Property)DoorBlock.field_176521_M))).func_206870_a((Property)DoorBlock.field_176519_b, source.func_177229_b((Property)DoorBlock.field_176519_b))).func_206870_a((Property)DoorBlock.field_176522_N, source.func_177229_b((Property)DoorBlock.field_176522_N));
        return state;
    }

    private BlockState copyTrapdoor(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)TrapDoorBlock.field_185512_D, source.func_177229_b((Property)TrapDoorBlock.field_185512_D))).func_206870_a((Property)TrapDoorBlock.field_176285_M, source.func_177229_b((Property)TrapDoorBlock.field_176285_M))).func_206870_a((Property)TrapDoorBlock.field_176283_b, source.func_177229_b((Property)TrapDoorBlock.field_176283_b))).func_206870_a((Property)TrapDoorBlock.field_196381_c, source.func_177229_b((Property)TrapDoorBlock.field_196381_c))).func_206870_a((Property)TrapDoorBlock.field_204614_t, source.func_177229_b((Property)TrapDoorBlock.field_204614_t));
        return state;
    }

    private BlockState copyPane(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, source.func_177229_b((Property)PaneBlock.field_196411_b))).func_206870_a((Property)PaneBlock.field_196409_a, source.func_177229_b((Property)PaneBlock.field_196409_a))).func_206870_a((Property)PaneBlock.field_196413_c, source.func_177229_b((Property)PaneBlock.field_196413_c))).func_206870_a((Property)PaneBlock.field_196414_y, source.func_177229_b((Property)PaneBlock.field_196414_y))).func_206870_a((Property)PaneBlock.field_204514_u, source.func_177229_b((Property)PaneBlock.field_204514_u));
        return state;
    }

    public BlockState getFoundationBlock(BlockState input) {
        return this.getFullState(input, this.foundationBlocks);
    }

    public BlockState getFoundationSlab(BlockState input) {
        return this.getSlabState(input, this.foundationSlabs);
    }

    public BlockState getFoundationStair(BlockState input) {
        return this.getStairState(input, this.foundationStairs);
    }

    public BlockState getFoundationWall(BlockState input) {
        if (this.foundationWalls.isEmpty()) {
            return input;
        }
        if (this.foundationWalls.size() == 1) {
            return this.copyWall(input, this.foundationWalls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.foundationWalls));
    }

    public BlockState getRoofBlock(BlockState input) {
        return this.getFullState(input, this.roofBlocks);
    }

    public BlockState getRoofSlab(BlockState input) {
        return this.getSlabState(input, this.roofSlabs);
    }

    public BlockState getRoofStair(BlockState input) {
        return this.getStairState(input, this.roofStairs);
    }

    public BlockState getPlanksBlock(BlockState input) {
        return this.getFullState(input, this.planksBlocks);
    }

    public BlockState getPlanksSlab(BlockState input) {
        return this.getSlabState(input, this.planksSlabs);
    }

    public BlockState getPlanksStair(BlockState input) {
        return this.getStairState(input, this.planksStairs);
    }

    public BlockState getFence(BlockState input) {
        if (this.fences.isEmpty()) {
            return input;
        }
        if (this.fences.size() == 1) {
            return this.copyFence(input, this.fences.get(0));
        }
        return this.copyFence(input, this.getRandomBlock(input, this.fences));
    }

    public BlockState getWall(BlockState input) {
        if (this.walls.isEmpty()) {
            return input;
        }
        if (this.walls.size() == 1) {
            return this.copyWall(input, this.walls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.walls));
    }

    public BlockState getGate(BlockState input) {
        if (this.gates.isEmpty()) {
            return input;
        }
        if (this.gates.size() == 1) {
            return this.copyGate(input, this.gates.get(0));
        }
        return this.copyGate(input, this.getRandomBlock(input, this.gates));
    }

    public BlockState getLog(BlockState input) {
        if (this.logs.isEmpty()) {
            return input;
        }
        if (this.logs.size() == 1) {
            return this.copyPillar(input, this.logs.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.logs));
    }

    public BlockState getBark(BlockState input) {
        if (this.bark.isEmpty()) {
            return input;
        }
        if (this.bark.size() == 1) {
            return this.copyPillar(input, this.bark.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.bark));
    }

    public BlockState getStoneBlock(BlockState input) {
        return this.getFullState(input, this.stoneBlocks);
    }

    public BlockState getStoneSlab(BlockState input) {
        return this.getSlabState(input, this.stoneSlabs);
    }

    public BlockState getStoneStair(BlockState input) {
        return this.getStairState(input, this.stoneStairs);
    }

    public BlockState getGlowingBlock(BlockState input) {
        return this.getFullState(input, this.glowingBlocks);
    }

    public BlockState getWallLight(BlockState input) {
        if (this.wallLights.isEmpty()) {
            return input;
        }
        if (this.wallLights.size() == 1) {
            return this.copyLanternWall(input, this.bark.get(0));
        }
        return this.copyLanternWall(input, this.getRandomBlock(input, this.wallLights));
    }

    public BlockState getCeilingLight(BlockState input) {
        return this.copyLanternCeiling(input, this.getRandomBlock(input, this.ceilingLights));
    }

    public BlockState getFloorLight(BlockState input) {
        return this.getFullState(input, this.ceilingLights);
    }

    public BlockState getDoor(BlockState input) {
        return this.copyDoor(input, this.getRandomBlock(input, this.doors));
    }

    public BlockState getTrapdoor(BlockState input) {
        return this.copyTrapdoor(input, this.getRandomBlock(input, this.trapdoors));
    }

    public BlockState getWoodenPlate(BlockState input) {
        return this.getFullState(input, this.platesWood);
    }

    public BlockState getStonePlate(BlockState input) {
        return this.getFullState(input, this.platesStone);
    }

    public BlockState getGlassBlock(BlockState input) {
        return this.getFullState(input, this.glassBlocks);
    }

    public BlockState getGlassPane(BlockState input) {
        return this.copyPane(input, this.getRandomBlock(input, this.glassPanes));
    }

    public BlockState getPot(BlockState input) {
        return this.getFullState(input, this.pots);
    }

    public BlockState getPlant(BlockState input) {
        String seed = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)input.func_177230_c()).func_110623_a();
        RANDOM.setSeed(seed.hashCode());
        return (BlockState)BlocksRegistry.POTTED_PLANT.func_176223_P().func_206870_a(BlockPottedPlant.PLANT, (Comparable)((Object)BlockPottedPlant.PottedPlantShape.values()[RANDOM.nextInt(BlockPottedPlant.PottedPlantShape.values().length)]));
    }
}

