/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureWartCap
implements IStructure {
    private static final BlockState INSIDE = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150419_aX.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
    private static final BlockState SKIN = Blocks.field_189878_dg.func_176223_P();
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        int z;
        int x;
        int y;
        if (!this.isWall(world, pos) || pos.func_177956_o() > 57 || pos.func_177956_o() < 34 || world.func_175623_d(pos.func_177979_c(3))) {
            return;
        }
        int radius = 3 + random.nextInt(3);
        int r2 = radius * radius;
        int side = radius * 2 + 1;
        int y1 = radius >> 1;
        BlockState[][][] shape = new BlockState[side][y1 + 1][side];
        for (y = 0; y <= y1; ++y) {
            POS.func_185336_p(pos.func_177956_o() + y);
            for (x = -radius; x <= radius; ++x) {
                POS.func_223471_o(pos.func_177958_n() + x);
                int sx = x + radius;
                for (int z2 = -radius; z2 <= radius; ++z2) {
                    POS.func_223472_q(pos.func_177952_p() + z2);
                    int sz = z2 + radius;
                    int d = x * x + y * y * 6 + z2 * z2;
                    if (d > r2) continue;
                    shape[sx][y][sz] = y == y1 || x == -radius || x == radius || z2 == -radius || z2 == radius ? SKIN : INSIDE;
                }
            }
        }
        for (y = 0; y < y1; ++y) {
            for (x = 1; x < side - 1; ++x) {
                for (z = 1; z < side - 1; ++z) {
                    if (shape[x][y][z] == null || shape[x - 1][y][z] != null && shape[x + 1][y][z] != null && shape[x][y][z - 1] != null && shape[x][y][z + 1] != null && shape[x][y + 1][z] != null) continue;
                    shape[x][y][z] = SKIN;
                }
            }
        }
        for (y = 0; y <= y1; ++y) {
            POS.func_185336_p(pos.func_177956_o() + y);
            for (x = 0; x < side; ++x) {
                POS.func_223471_o(pos.func_177958_n() + x - radius);
                for (z = 0; z < side; ++z) {
                    POS.func_223472_q(pos.func_177952_p() + z - radius);
                    if (shape[x][y][z] == null || !world.func_175623_d((BlockPos)POS)) continue;
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, shape[x][y][z]);
                }
            }
        }
    }

    private boolean isWall(IServerWorld world, BlockPos pos) {
        for (Direction dir : HorizontalBlock.field_185512_D.func_177700_c()) {
            if (world.func_180495_p(pos.func_177972_a(dir)).func_177230_c() != Blocks.field_196653_dH) continue;
            return true;
        }
        return false;
    }
}

