/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.decorations;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BlockStalactite;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureStalagmite
implements IStructure {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private final Block block;
    private final Block under;
    private final Block[] ground;

    public StructureStalagmite(Block block, Block under) {
        this.block = block;
        this.ground = null;
        this.under = under;
    }

    public StructureStalagmite(Block block, Block under, Block ... ground) {
        this.block = block;
        this.under = under;
        this.ground = ground;
    }

    private boolean canPlaceAt(IServerWorld world, BlockPos pos) {
        return world.func_175623_d(pos) && (this.ground == null ? BlocksHelper.isNetherGround(world.func_180495_p(pos.func_177977_b())) : this.groundContains(world.func_180495_p(pos.func_177977_b()).func_177230_c()));
    }

    private boolean groundContains(Block block) {
        for (Block b : this.ground) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (this.canPlaceAt(world, pos)) {
            block0: for (int i = 0; i < 16; ++i) {
                int offset;
                boolean stalagnate;
                int h;
                int dz;
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                int z = pos.func_177952_p() + (int)(random.nextGaussian() * 2.0);
                POS.func_181079_c(x, pos.func_177956_o(), z);
                int y = pos.func_177956_o() - BlocksHelper.downRay((IWorld)world, (BlockPos)POS, 8);
                if (!this.canPlaceAt(world, (BlockPos)POS)) continue;
                int dx = x - pos.func_177958_n();
                float dist = 4.0f - (float)Math.sqrt(dx * dx + (dz = z - pos.func_177952_p()) * dz);
                if (dist < 1.0f) {
                    dist = 1.0f;
                }
                h = (h = (int)((float)random.nextInt((int)Math.ceil(dist + 1.0f)) + dist + (float)random.nextInt(2))) > 8 ? 8 : h;
                POS.func_185336_p(y);
                int h2 = BlocksHelper.upRay((IWorld)world, (BlockPos)POS, h + 2) + 1;
                POS.func_185336_p(y + h2);
                boolean bl = stalagnate = h2 <= h && BlocksHelper.isNetherrack(world.func_180495_p((BlockPos)POS));
                if (h2 <= h) {
                    h = h2;
                }
                int n = stalagnate ? (h < 8 ? MHelper.randRange(0, 8 - h, random) : 0) : (offset = 0);
                if (this.under != null && h > 2) {
                    POS.func_185336_p(y - 1);
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, this.under.func_176223_P());
                    if (stalagnate) {
                        POS.func_185336_p(y + h);
                        BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, this.under.func_176223_P());
                    }
                }
                for (int n2 = 0; n2 < h; ++n2) {
                    POS.func_185336_p(y + n2);
                    if (!world.func_175623_d((BlockPos)POS)) continue block0;
                    int size = stalagnate ? Math.abs(h / 2 - n2) + offset : h - n2 - 1;
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, (BlockState)this.block.func_176223_P().func_206870_a((Property)BlockStalactite.SIZE, (Comparable)Integer.valueOf(size)));
                }
            }
        }
    }
}

