/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.recipes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import someoneelse.betternetherreforged.recipes.BNRecipeManager;

public class RecipesHelper {
    private static final String[] SHAPE_ROOF = new String[]{"# #", "###", " # "};
    private static final String[] SHAPE_STAIR = new String[]{"#  ", "## ", "###"};
    private static final String[] SHAPE_SLAB = new String[]{"###"};
    private static final String[] SHAPE_BUTTON = new String[]{"#"};
    private static final String[] SHAPE_PLATE = new String[]{"##"};
    private static final String[] SHAPE_X2 = new String[]{"##", "##"};
    private static final String[] SHAPE_FG = new String[]{"#I#", "#I#"};
    private static final String[] SHAPE_2X3 = new String[]{"##", "##", "##"};
    private static final String[] SHAPE_3X2 = new String[]{"###", "###"};
    private static final String[] SHAPE_COLORING = new String[]{"###", "#I#", "###"};
    private static final String[] SHAPE_ROUND = new String[]{"###", "# #", "###"};
    private static final String[] SHAPE_SIGN = new String[]{"###", "###", " I "};
    private static final String[] SHAPE_BARREL = new String[]{"#S#", "# #", "#S#"};
    private static final String[] SHAPE_LADDER = new String[]{"I I", "I#I", "I I"};
    private static final String[] SHAPE_TABURET = new String[]{"##", "II"};
    private static final String[] SHAPE_CHAIR = new String[]{"I ", "##", "II"};
    private static final String[] SHAPE_BAR_STOOL = new String[]{"##", "II", "II"};
    private static final String[] SHAPE_FIRE_BOWL = new String[]{"#I#", " # ", "L L"};

    private static void makeSingleRecipe(String group, Block source, Block result, String[] shape, int count) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source).func_110623_a() + "_" + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source));
            BNRecipeManager.addCraftingRecipe(name, group, shape, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result, count));
        }
    }

    public static void makeRoofRecipe(Block source, Block roof) {
        RecipesHelper.makeSingleRecipe("roof_tile", source, roof, SHAPE_ROOF, 6);
    }

    public static void makeStairsRecipe(Block source, Block stairs) {
        String group = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)stairs).func_110623_a().contains("roof_tile") ? "roof_tile_stairs" : (stairs.func_220072_p(stairs.func_176223_P()) == SoundType.field_185848_a ? "nether_wooden_stairs" : "nether_rock_stairs");
        RecipesHelper.makeSingleRecipe(group, source, stairs, SHAPE_STAIR, 4);
    }

    public static void makeSlabRecipe(Block source, Block slab) {
        String group = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)slab).func_110623_a().contains("roof_tile") ? "roof_tile_slab" : (slab.func_220072_p(slab.func_176223_P()) == SoundType.field_185848_a ? "nether_wooden_slab" : "nether_rock_slab");
        RecipesHelper.makeSingleRecipe(group, source, slab, SHAPE_SLAB, 6);
    }

    public static void makeButtonRecipe(Block source, Block button) {
        String group = button.func_220072_p(button.func_176223_P()) == SoundType.field_185848_a ? "nether_wooden_button" : "nether_rock_button";
        RecipesHelper.makeSingleRecipe(group, source, button, SHAPE_BUTTON, 1);
    }

    public static void makePlateRecipe(Block source, Block plate) {
        String group = plate.func_220072_p(plate.func_176223_P()) == SoundType.field_185848_a ? "nether_wooden_plate" : "nether_rock_plate";
        RecipesHelper.makeSingleRecipe(group, source, plate, SHAPE_PLATE, 1);
    }

    public static void makeSimpleRecipe(Block source, Block result, int count, String group) {
        RecipesHelper.makeSingleRecipe(group, source, result, SHAPE_BUTTON, count);
    }

    public static void makeSimpleRecipe2(Block source, Block result, int count, String group) {
        RecipesHelper.makeSingleRecipe(group, source, result, SHAPE_X2, count);
    }

    public static void makeFenceRecipe(Block source, Block fence) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)fence).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"I", (Object)new ItemStack((IItemProvider)Items.field_151055_y));
            BNRecipeManager.addCraftingRecipe(name, "nether_fence", SHAPE_FG, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)fence, 3));
        }
    }

    public static void makeGateRecipe(Block source, Block gate) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)gate).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"I", (Object)new ItemStack((IItemProvider)source), (Object)"#", (Object)new ItemStack((IItemProvider)Items.field_151055_y));
            BNRecipeManager.addCraftingRecipe(name, "nether_gate", SHAPE_FG, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)gate));
        }
    }

    public static void makeDoorRecipe(Block source, Block result) {
        RecipesHelper.makeSingleRecipe("nether_door", source, result, SHAPE_2X3, 3);
    }

    public static void makeTrapdoorRecipe(Block source, Block result) {
        RecipesHelper.makeSingleRecipe("nether_trapdoor", source, result, SHAPE_3X2, 2);
    }

    public static void makeWallRecipe(Block source, Block wall) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)wall).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source));
            BNRecipeManager.addCraftingRecipe(name, "nether_wall", SHAPE_3X2, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)wall, 6));
        }
    }

    public static void makeColoringRecipe(Block source, Block result, Item dye, String group) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"I", (Object)new ItemStack((IItemProvider)dye));
            BNRecipeManager.addCraftingRecipe(name, group, SHAPE_COLORING, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result, 8));
        }
    }

    public static void makeRoundRecipe(Block source, Block result, String group) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source));
            BNRecipeManager.addCraftingRecipe(name, group, SHAPE_ROUND, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result));
        }
    }

    public static void makeSignRecipe(Block source, Block result) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"I", (Object)new ItemStack((IItemProvider)Items.field_151055_y));
            BNRecipeManager.addCraftingRecipe(name, "nether_sign", SHAPE_SIGN, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result, 3));
        }
    }

    public static void makeBarrelRecipe(Block source, Block slab, Block result) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"S", (Object)new ItemStack((IItemProvider)slab));
            BNRecipeManager.addCraftingRecipe(name, "nether_barrel", SHAPE_BARREL, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result));
        }
    }

    public static void makeLadderRecipe(Block source, Block result) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"I", (Object)new ItemStack((IItemProvider)Items.field_151055_y));
            BNRecipeManager.addCraftingRecipe(name, "nether_ladder", SHAPE_LADDER, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result, 3));
        }
    }

    public static void makeTaburetRecipe(Block source, Block result) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"I", (Object)new ItemStack((IItemProvider)Items.field_151055_y));
            BNRecipeManager.addCraftingRecipe(name, "nether_ladder", SHAPE_TABURET, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result));
        }
    }

    public static void makeChairRecipe(Block source, Block result) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"I", (Object)new ItemStack((IItemProvider)Items.field_151055_y));
            BNRecipeManager.addCraftingRecipe(name, "nether_ladder", SHAPE_CHAIR, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result));
        }
    }

    public static void makeBarStoolRecipe(Block source, Block result) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)source) != ForgeRegistries.BLOCKS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)source), (Object)"I", (Object)new ItemStack((IItemProvider)Items.field_151055_y));
            BNRecipeManager.addCraftingRecipe(name, "nether_ladder", SHAPE_BAR_STOOL, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result));
        }
    }

    public static void makeFireBowlRecipe(Block material, Block inside, Item leg, Block result) {
        if (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)material) != ForgeRegistries.BLOCKS.getDefaultKey() && ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)inside) != ForgeRegistries.BLOCKS.getDefaultKey() && ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)leg) != ForgeRegistries.ITEMS.getDefaultKey()) {
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)result).func_110623_a();
            ImmutableMap materials = ImmutableMap.of((Object)"#", (Object)new ItemStack((IItemProvider)material), (Object)"I", (Object)new ItemStack((IItemProvider)inside), (Object)"L", (Object)new ItemStack((IItemProvider)leg));
            BNRecipeManager.addCraftingRecipe(name, "fire_bowl", SHAPE_FIRE_BOWL, (Map<String, ItemStack>)materials, new ItemStack((IItemProvider)result));
        }
    }
}

