/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import someoneelse.betternetherreforged.config.Configs;

public class BNRecipeManager {
    private static final Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> RECIPES = Maps.newHashMap();

    public static void addRecipe(IRecipeType<?> type, IRecipe<?> recipe) {
        if (Configs.RECIPES.getBoolean("recipes", recipe.func_199560_c().func_110623_a(), true)) {
            HashMap list = RECIPES.get(type);
            if (list == null) {
                list = Maps.newHashMap();
                RECIPES.put(type, list);
            }
            list.put(recipe.func_199560_c(), recipe);
        }
    }

    public static Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> getMap(Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipes) {
        HashMap result = Maps.newHashMap();
        for (IRecipeType<?> type : recipes.keySet()) {
            HashMap typeList = Maps.newHashMap();
            typeList.putAll(recipes.get(type));
            result.put(type, typeList);
        }
        for (IRecipeType<?> type : RECIPES.keySet()) {
            Map<ResourceLocation, IRecipe<?>> list = RECIPES.get(type);
            if (list == null) continue;
            Map typeList = (Map)result.get(type);
            list.forEach((id, recipe) -> {
                if (!typeList.containsKey(id)) {
                    typeList.put(id, recipe);
                }
            });
        }
        return result;
    }

    public static NonNullList<Ingredient> getIngredients(String[] pattern, Map<String, Ingredient> key, int width, int height) {
        NonNullList defaultedList = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(key.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                Ingredient ingredient = key.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return defaultedList;
    }

    public static void addCraftingRecipe(String name, String[] shape, Map<String, ItemStack> materials, ItemStack result) {
        BNRecipeManager.addCraftingRecipe(name, "", shape, materials, result);
    }

    public static void addCraftingRecipe(String name, String group, String[] shape, Map<String, ItemStack> materials, ItemStack result) {
        int width = shape[0].length();
        int height = shape.length;
        HashMap<String, Ingredient> mapIng = new HashMap<String, Ingredient>();
        mapIng.put(" ", Ingredient.field_193370_a);
        materials.forEach((id, material) -> mapIng.put((String)id, BNRecipeManager.fromStacks(material)));
        NonNullList<Ingredient> list = BNRecipeManager.getIngredients(shape, mapIng, width, height);
        ShapedRecipe recipe = new ShapedRecipe(new ResourceLocation("betternether", name), group, width, height, list, result);
        BNRecipeManager.addRecipe(IRecipeType.field_222149_a, recipe);
    }

    private static Ingredient fromStacks(ItemStack ... stacks) {
        return Ingredient.func_234819_a_(Arrays.stream(stacks));
    }

    public static ShapelessRecipe makeEmtyRecipe(ResourceLocation id) {
        ShapelessRecipe recipe = new ShapelessRecipe(id, "empty", new ItemStack((IItemProvider)Items.field_190931_a), NonNullList.func_191196_a());
        return recipe;
    }
}

